/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.event.DeferredEventNotification;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.event.Status;
import org.jboss.weld.event.TransactionSynchronizedRunnable;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.transaction.spi.TransactionServices;

public class TransactionalObserverNotifier
extends ObserverNotifier {
    private final TransactionServices transactionServices;
    private final String contextId;

    protected TransactionalObserverNotifier(String contextId, TypeSafeObserverResolver resolver, ServiceRegistry services, boolean strict) {
        super(resolver, services, strict);
        this.contextId = contextId;
        this.transactionServices = (TransactionServices)services.get(TransactionServices.class);
    }

    private <T> void deferNotification(T event, EventMetadata metadata, ObserverMethod<? super T> observer) {
        DeferredEventNotification<? super T> deferredEvent = new DeferredEventNotification<T>(this.contextId, event, metadata, observer, this.currentEventMetadata);
        TransactionPhase transactionPhase = observer.getTransactionPhase();
        if (transactionPhase.equals((Object)TransactionPhase.BEFORE_COMPLETION)) {
            this.transactionServices.registerSynchronization((Synchronization)new TransactionSynchronizedRunnable(deferredEvent, true));
        } else if (transactionPhase.equals((Object)TransactionPhase.AFTER_COMPLETION)) {
            this.transactionServices.registerSynchronization((Synchronization)new TransactionSynchronizedRunnable(deferredEvent, false));
        } else if (transactionPhase.equals((Object)TransactionPhase.AFTER_SUCCESS)) {
            this.transactionServices.registerSynchronization((Synchronization)new TransactionSynchronizedRunnable(deferredEvent, Status.SUCCESS));
        } else if (transactionPhase.equals((Object)TransactionPhase.AFTER_FAILURE)) {
            this.transactionServices.registerSynchronization((Synchronization)new TransactionSynchronizedRunnable(deferredEvent, Status.FAILURE));
        }
    }

    @Override
    protected <T> void notifyTransactionObservers(List<ObserverMethod<? super T>> observers, T event, EventMetadata metadata) {
        if (observers.isEmpty()) {
            return;
        }
        if (this.transactionServices == null || !this.transactionServices.isTransactionActive()) {
            this.notifySyncObservers(observers, event, metadata);
        } else {
            ArrayList failedObservers = new ArrayList(observers);
            try {
                for (ObserverMethod observerMethod : observers) {
                    this.deferNotification(event, metadata, observerMethod);
                    failedObservers.remove(observerMethod);
                }
            }
            catch (Exception e) {
                if (e.getCause() instanceof RollbackException || e.getCause() instanceof IllegalStateException) {
                    ArrayList arrayList = new ArrayList(failedObservers);
                    Iterator it = arrayList.iterator();
                    while (it.hasNext()) {
                        ObserverMethod observerMethod = (ObserverMethod)it.next();
                        if (!observerMethod.getTransactionPhase().equals((Object)TransactionPhase.AFTER_SUCCESS)) continue;
                        it.remove();
                    }
                    Collections.sort(arrayList, new Comparator<ObserverMethod<? super T>>(){

                        @Override
                        public int compare(ObserverMethod<? super T> o1, ObserverMethod<? super T> o2) {
                            return o2.getTransactionPhase().toString().compareTo(o1.getTransactionPhase().toString());
                        }
                    });
                    this.notifySyncObservers(arrayList, event, metadata);
                }
                throw e;
            }
        }
    }
}

