/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.general;

import java.util.List;
import java.util.regex.Pattern;
import org.jboss.windup.config.condition.GraphCondition;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.rules.general.IterableFilter;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="iterable-filter", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class IterableFilterHandler
implements ElementHandler<IterableFilter> {
    public static final String ELEMENT_NAME = "iterable-filter";
    public static final String SIZE_ATTRIBUTE = "size";

    public IterableFilter processElement(ParserContext context, Element element) throws ConfigurationException {
        String sizeAttr = JOOX.$((Element)element).attr(SIZE_ATTRIBUTE);
        List children = JOOX.$((Element)element).children().get();
        this.validateAttributes(sizeAttr);
        this.validateChildren(children);
        Element firstChild = (Element)children.get(0);
        Object wrappedCondition = context.processElement(firstChild);
        this.validateWrappedCondition(wrappedCondition);
        IterableFilter iterableFilter = new IterableFilter(Integer.parseInt(sizeAttr));
        for (Element child : children) {
            Object condition = context.processElement(child);
            iterableFilter.withWrappedCondition((GraphCondition)condition);
        }
        return iterableFilter;
    }

    private void validateWrappedCondition(Object wrappedCondition) {
        if (!(wrappedCondition instanceof GraphCondition)) {
            throw new WindupException("The <iterable-filter> element must wrap GraphConditions only.");
        }
    }

    private void validateAttributes(String size) throws WindupException {
        if (!Pattern.matches("[0-9]+", size)) {
            throw new WindupException("The <iterable-filter> element's 'size attribute is not a valid number.");
        }
    }

    private void validateChildren(List<Element> children) throws WindupException {
        if (children.size() != 1) {
            throw new WindupException("The <iterable-filter> element must have exactly 1 child.");
        }
    }
}

