/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource.zip;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.UnzipParameters;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.VirtualResource;
import org.jboss.forge.addon.resource.zip.ZipFileResource;
import org.jboss.forge.addon.resource.zip.ZipFileResourceEntry;
import org.jboss.forge.addon.resource.zip.ZipFileResourceImpl;
import org.jboss.forge.furnace.util.Assert;

public class ZipFileResourceEntryImpl
extends VirtualResource<String>
implements ZipFileResourceEntry {
    private final FileHeader fileHeader;

    public ZipFileResourceEntryImpl(ResourceFactory factory, ZipFileResource parent, FileHeader fileHeader) {
        super(factory, (Resource)parent);
        Assert.notNull((Object)fileHeader, (String)"File header should not be null");
        this.fileHeader = fileHeader;
    }

    public boolean delete() {
        try {
            this.getZipFile().removeFile(this.fileHeader);
        }
        catch (ZipException e) {
            throw new ResourceException("Error while deleting zip entry", (Throwable)e);
        }
        return true;
    }

    public InputStream getResourceInputStream() {
        try {
            return this.getZipFile().getInputStream(this.fileHeader);
        }
        catch (ZipException e) {
            throw new ResourceException("Error while fetching zip contents", (Throwable)e);
        }
    }

    public boolean delete(boolean recursive) throws UnsupportedOperationException {
        return this.delete();
    }

    public String getName() {
        return this.fileHeader.getFileName();
    }

    public String getUnderlyingResourceObject() {
        return this.getName();
    }

    protected List<Resource<?>> doListResources() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getName();
    }

    public void extractTo(DirectoryResource directoryResource, String newName) {
        try {
            UnzipParameters parameters = new UnzipParameters();
            this.getZipFile().extractFile(this.fileHeader, directoryResource.getFullyQualifiedName(), parameters, newName);
        }
        catch (ZipException e) {
            throw new ResourceException("Error while fetching zip contents", (Throwable)e);
        }
    }

    public void extractTo(DirectoryResource directoryResource) {
        try {
            UnzipParameters parameters = new UnzipParameters();
            this.getZipFile().extractFile(this.fileHeader, directoryResource.getFullyQualifiedName(), parameters);
        }
        catch (ZipException e) {
            throw new ResourceException("Error while fetching zip contents", (Throwable)e);
        }
    }

    public boolean isDirectory() {
        return this.fileHeader.isDirectory();
    }

    private ZipFile getZipFile() {
        ZipFileResourceImpl impl = (ZipFileResourceImpl)this.getParent();
        return impl.getZipFile();
    }
}

