/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.decompiler;

import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.DecompilationPhase;
import org.jboss.windup.rules.apps.java.condition.SourceMode;
import org.jboss.windup.rules.apps.java.decompiler.BeforeDecompileClassesRuleProvider;
import org.jboss.windup.rules.apps.java.decompiler.CleanFromMultipleSourceFiles;
import org.jboss.windup.rules.apps.java.decompiler.FernflowerDecompilerOperation;
import org.jboss.windup.rules.apps.java.decompiler.ProcyonDecompilerOperation;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=DecompilationPhase.class, after={BeforeDecompileClassesRuleProvider.class})
public class DecompileClassesRuleProvider
extends AbstractRuleProvider {
    public static final String DECOMPILER_PROPERTY = "windup.decompiler";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)SourceMode.isDisabled()).perform((Operation)new DecompileCondition()).addRule().when((Condition)SourceMode.isDisabled()).perform((Operation)new CleanFromMultipleSourceFiles());
    }

    private class DecompileCondition
    extends GraphOperation {
        private DecompileCondition() {
        }

        public void perform(GraphRewrite event, EvaluationContext context) {
            switch (this.getDecompilerType()) {
                case FERNFLOWER: {
                    new FernflowerDecompilerOperation().perform(event, context);
                    break;
                }
                case PROCYON: {
                    new ProcyonDecompilerOperation().perform(event, context);
                    break;
                }
                default: {
                    throw new WindupException("Failed to select decompiler due to unrecognized type: " + (Object)((Object)this.getDecompilerType()));
                }
            }
        }

        private DecompilerType getDecompilerType() {
            String decompilerProperty = System.getProperty(DecompileClassesRuleProvider.DECOMPILER_PROPERTY);
            if (StringUtils.isBlank((CharSequence)decompilerProperty)) {
                return DecompilerType.FERNFLOWER;
            }
            return DecompilerType.valueOf(decompilerProperty.toUpperCase());
        }
    }

    private static enum DecompilerType {
        PROCYON,
        FERNFLOWER;

    }
}

