/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.freemarker;

import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.model.ApplicationReportIndexModel;
import org.jboss.windup.reporting.service.ApplicationReportIndexService;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;

public class ProjectModelToSha1
implements WindupFreeMarkerMethod {
    private static Logger LOG = Logging.get(ProjectModelToSha1.class);
    private static final String NAME = "projectModelToSha1";
    private ApplicationReportIndexService service;

    public void setContext(GraphRewrite event) {
        this.service = new ApplicationReportIndexService(event.getGraphContext());
    }

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Takes a parameter of type " + ProjectModel.class.getSimpleName() + " and returns the associated " + ApplicationReportIndexModel.class.getSimpleName() + ".";
    }

    public Object exec(List arguments) throws TemplateModelException {
        String result = null;
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() != 1) {
            throw new TemplateModelException("Error, method expects one argument (ProjectModel)");
        }
        StringModel stringModelArg = (StringModel)arguments.get(0);
        if (stringModelArg == null) {
            throw new IllegalArgumentException("FreeMarker Method projectModelToSha1 called with null project model");
        }
        ProjectModel projectModel = (ProjectModel)stringModelArg.getWrappedObject();
        if (projectModel.getRootFileModel() instanceof IdentifiedArchiveModel) {
            result = projectModel.getRootFileModel().getSHA1Hash();
        }
        ExecutionStatistics.get().end(NAME);
        return result;
    }
}

