/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.mavenize;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.rules.apps.java.archives.model.ArchiveCoordinateModel;

public class MavenCoord {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String packaging;
    private String scope;
    private String comment;
    private Set<MavenCoord> exclusions = new HashSet<MavenCoord>();
    public static final Pattern REGEX_GAVCP = Pattern.compile("([^: ]+):([^: ]+):([^: ]+)(:[^: ]+)?(:[^: ]+)?");

    MavenCoord() {
    }

    static MavenCoord from(ArchiveCoordinateModel coordinate) {
        return new MavenCoord().setGroupId(coordinate.getGroupId()).setArtifactId(coordinate.getArtifactId()).setVersion(coordinate.getVersion()).setClassifier(coordinate.getClassifier()).setPackaging(coordinate.getPackaging());
    }

    public static MavenCoord fromGAVPC(String coordGavpc) {
        Matcher mat = REGEX_GAVCP.matcher(coordGavpc);
        if (!mat.matches()) {
            throw new IllegalArgumentException("Wrong Maven coordinates format, must be G:A:V[:P[:C]] . " + coordGavpc);
        }
        return new MavenCoord().setGroupId(mat.group(1)).setArtifactId(mat.group(2)).setVersion(mat.group(3)).setPackaging(mat.group(4)).setClassifier(mat.group(5));
    }

    MavenCoord(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, "pom");
    }

    MavenCoord(String groupId, String artifactId, String version, String packaging) {
        this(groupId, artifactId, version, null, packaging);
    }

    MavenCoord(String groupId, String artifactId, String version, String classifier, String packaging) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.packaging = packaging;
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode(this.getGroupId());
        hash = 79 * hash + Objects.hashCode(this.getArtifactId());
        hash = 79 * hash + Objects.hashCode(this.getVersion());
        hash = 79 * hash + Objects.hashCode(this.getClassifier());
        hash = 79 * hash + Objects.hashCode(this.getPackaging());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenCoord other = (MavenCoord)obj;
        if (!Objects.equals(this.groupId, other.groupId)) {
            return false;
        }
        if (!Objects.equals(this.artifactId, other.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        if (!Objects.equals(this.classifier, other.classifier)) {
            return false;
        }
        return Objects.equals(this.packaging, other.packaging);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public MavenCoord setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public MavenCoord setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public MavenCoord setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public MavenCoord setClassifier(String classifier) {
        this.classifier = classifier;
        return this;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public MavenCoord setPackaging(String packaging) {
        this.packaging = packaging;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public MavenCoord setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public MavenCoord setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Set<MavenCoord> getExclusions() {
        return this.exclusions;
    }

    public MavenCoord addExclusion(MavenCoord coord) {
        this.getExclusions().add(coord);
        return this;
    }

    public String toString() {
        return '{' + this.groupId + ":" + this.artifactId + ":" + this.version + ":" + StringUtils.defaultString((String)this.classifier) + ":" + this.packaging + ",s:" + this.scope + '}';
    }
}

