/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.management;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.graphdb.types.CompositeIndexType;
import com.thinkaurelius.titan.graphdb.types.IndexField;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.MixedIndexType;
import com.tinkerpop.blueprints.Element;

public class TitanGraphIndexWrapper
implements TitanGraphIndex {
    private final IndexType index;

    public TitanGraphIndexWrapper(IndexType index) {
        this.index = index;
    }

    IndexType getBaseIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.index.getName();
    }

    @Override
    public String getBackingIndex() {
        return this.index.getBackingIndexName();
    }

    @Override
    public Class<? extends Element> getIndexedElement() {
        return this.index.getElement().getElementType();
    }

    @Override
    public PropertyKey[] getFieldKeys() {
        IndexField[] fields = this.index.getFieldKeys();
        PropertyKey[] keys = new PropertyKey[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            keys[i] = fields[i].getFieldKey();
        }
        return keys;
    }

    @Override
    public Parameter[] getParametersFor(PropertyKey key) {
        if (this.index.isCompositeIndex()) {
            return new Parameter[0];
        }
        return ((MixedIndexType)this.index).getField(key).getParameters();
    }

    @Override
    public boolean isUnique() {
        if (this.index.isMixedIndex()) {
            return false;
        }
        return ((CompositeIndexType)this.index).getCardinality() == Cardinality.SINGLE;
    }

    @Override
    public SchemaStatus getIndexStatus(PropertyKey key) {
        Preconditions.checkArgument((boolean)Sets.newHashSet((Object[])this.getFieldKeys()).contains(key), (String)"Provided key is not part of this index: %s", (Object[])new Object[]{key});
        if (this.index.isCompositeIndex()) {
            return ((CompositeIndexType)this.index).getStatus();
        }
        return ((MixedIndexType)this.index).getField(key).getStatus();
    }

    @Override
    public boolean isCompositeIndex() {
        return this.index.isCompositeIndex();
    }

    @Override
    public boolean isMixedIndex() {
        return this.index.isMixedIndex();
    }
}

