/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.log;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.log.Change;
import com.thinkaurelius.titan.core.log.ChangeState;
import com.thinkaurelius.titan.graphdb.internal.InternalRelation;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.tinkerpop.blueprints.Direction;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

class StandardChangeState
implements ChangeState {
    private final EnumMap<Change, Set<TitanVertex>> vertices = new EnumMap(Change.class);
    private final EnumMap<Change, Set<TitanRelation>> relations = new EnumMap(Change.class);

    StandardChangeState() {
        for (Change state : new Change[]{Change.ADDED, Change.REMOVED}) {
            this.vertices.put(state, new HashSet());
            this.relations.put(state, new HashSet());
        }
    }

    void addVertex(InternalVertex vertex, Change state) {
        this.vertices.get((Object)state).add(vertex);
    }

    void addRelation(InternalRelation rel, Change state) {
        this.relations.get((Object)state).add(rel);
    }

    @Override
    public Set<TitanVertex> getVertices(Change change) {
        if (change.isProper()) {
            return this.vertices.get((Object)change);
        }
        assert (change == Change.ANY);
        HashSet<TitanVertex> all = new HashSet<TitanVertex>();
        for (Change state : new Change[]{Change.ADDED, Change.REMOVED}) {
            all.addAll((Collection<TitanVertex>)this.vertices.get((Object)state));
            for (TitanRelation rel : this.relations.get((Object)state)) {
                InternalRelation irel = (InternalRelation)rel;
                for (int p = 0; p < irel.getLen(); ++p) {
                    all.add(irel.getVertex(p));
                }
            }
        }
        return all;
    }

    private <T> Set<T> toSet(T ... types) {
        if (types == null || types.length == 0) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet((Object[])types);
    }

    private Iterable<TitanRelation> getRelations(Change change, Predicate<TitanRelation> filter) {
        Iterable base = change.isProper() ? (Iterable)this.relations.get((Object)change) : Iterables.concat((Iterable)this.relations.get((Object)Change.ADDED), (Iterable)this.relations.get((Object)Change.REMOVED));
        return Iterables.filter((Iterable)base, filter);
    }

    @Override
    public Iterable<TitanRelation> getRelations(Change change, RelationType ... types) {
        final Set<RelationType> stypes = this.toSet(types);
        return this.getRelations(change, new Predicate<TitanRelation>(){

            public boolean apply(@Nullable TitanRelation titanRelation) {
                return stypes.isEmpty() || stypes.contains(titanRelation.getType());
            }
        });
    }

    @Override
    public Iterable<TitanEdge> getEdges(final TitanVertex vertex, Change change, final Direction dir, String ... labels) {
        final Set<String> stypes = this.toSet(labels);
        return this.getRelations(change, new Predicate<TitanRelation>(){

            public boolean apply(@Nullable TitanRelation titanRelation) {
                return !(!titanRelation.isEdge() || !titanRelation.isIncidentOn(vertex) || dir != Direction.BOTH && !((TitanEdge)titanRelation).getVertex(dir).equals(vertex) || !stypes.isEmpty() && !stypes.contains(titanRelation.getType().getName()));
            }
        });
    }

    @Override
    public Iterable<TitanEdge> getTitanEdges(final TitanVertex vertex, Change change, final Direction dir, EdgeLabel ... labels) {
        final Set<EdgeLabel> stypes = this.toSet(labels);
        return this.getRelations(change, new Predicate<TitanRelation>(){

            public boolean apply(@Nullable TitanRelation titanRelation) {
                return !(!titanRelation.isEdge() || !titanRelation.isIncidentOn(vertex) || dir != Direction.BOTH && !((TitanEdge)titanRelation).getVertex(dir).equals(vertex) || !stypes.isEmpty() && !stypes.contains(titanRelation.getType()));
            }
        });
    }

    @Override
    public Iterable<TitanProperty> getProperties(final TitanVertex vertex, Change change, String ... keys) {
        final Set<String> stypes = this.toSet(keys);
        return this.getRelations(change, new Predicate<TitanRelation>(){

            public boolean apply(@Nullable TitanRelation titanRelation) {
                return titanRelation.isProperty() && titanRelation.isIncidentOn(vertex) && (stypes.isEmpty() || stypes.contains(titanRelation.getType().getName()));
            }
        });
    }

    @Override
    public Iterable<TitanProperty> getTitanProperties(final TitanVertex vertex, Change change, PropertyKey ... keys) {
        final Set<PropertyKey> stypes = this.toSet(keys);
        return this.getRelations(change, new Predicate<TitanRelation>(){

            public boolean apply(@Nullable TitanRelation titanRelation) {
                return titanRelation.isProperty() && titanRelation.isIncidentOn(vertex) && (stypes.isEmpty() || stypes.contains(titanRelation.getType()));
            }
        });
    }
}

