/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.util;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertexQuery;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import com.tinkerpop.blueprints.Direction;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class VertexCentricEdgeIterable<R extends TitanRelation>
implements Iterable<R> {
    private final Iterable<InternalVertex> vertices;
    private final RelationCategory relationCategory;

    public VertexCentricEdgeIterable(Iterable<InternalVertex> vertices, RelationCategory relationCategory) {
        Preconditions.checkArgument((vertices != null && relationCategory != null ? 1 : 0) != 0);
        this.vertices = vertices;
        this.relationCategory = relationCategory;
    }

    @Override
    public Iterator<R> iterator() {
        return new EdgeIterator();
    }

    private class EdgeIterator
    implements Iterator<R> {
        private final Iterator<InternalVertex> vertexIter;
        private Iterator<TitanRelation> currentOutEdges;
        private TitanRelation nextEdge = null;

        public EdgeIterator() {
            this.vertexIter = VertexCentricEdgeIterable.this.vertices.iterator();
            if (this.vertexIter.hasNext()) {
                this.currentOutEdges = VertexCentricEdgeIterable.this.relationCategory.executeQuery((TitanVertexQuery)this.vertexIter.next().query().direction(Direction.OUT)).iterator();
                this.getNextEdge();
            }
        }

        private void getNextEdge() {
            assert (this.vertexIter != null && this.currentOutEdges != null);
            this.nextEdge = null;
            while (this.nextEdge == null) {
                if (this.currentOutEdges.hasNext()) {
                    this.nextEdge = this.currentOutEdges.next();
                    break;
                }
                if (!this.vertexIter.hasNext()) break;
                this.currentOutEdges = VertexCentricEdgeIterable.this.relationCategory.executeQuery((TitanVertexQuery)this.vertexIter.next().query().direction(Direction.OUT)).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextEdge != null;
        }

        @Override
        public R next() {
            if (this.nextEdge == null) {
                throw new NoSuchElementException();
            }
            TitanRelation returnEdge = this.nextEdge;
            this.getNextEdge();
            return returnEdge;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

