/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.utilities;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import javax.transaction.xa.XAException;

public class MiscUtils {
    public static XAException createXAExceptionWithCause(int errorCode, Throwable cause) {
        XAException xae = new XAException(errorCode);
        xae.initCause(cause);
        return xae;
    }

    public static boolean isRootPath(File f) {
        if (f.getParentFile() == null) {
            return true;
        }
        if (f.getAbsolutePath().startsWith("\\\\")) {
            File parent = f.getParentFile();
            File grandParent = parent.getParentFile();
            if (grandParent == null) {
                return false;
            }
            if (grandParent.getParentFile() == null) {
                return true;
            }
        }
        return false;
    }

    public static void closeAll(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

