/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph;

import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.modules.MethodHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.windup.graph.MapInProperties;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;

public class MapInPropertiesHandler
implements MethodHandler<MapInProperties> {
    private static final Logger log = Logging.get(MapInPropertiesHandler.class);

    public Class<MapInProperties> getAnnotationType() {
        return MapInProperties.class;
    }

    public Object processElement(Object frame, Method method, Object[] args, MapInProperties ann, FramedGraph<?> framedGraph, Element elm) {
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return this.handleGetter((Vertex)elm, method, args, ann, framedGraph);
        }
        if (methodName.startsWith("set")) {
            return this.handleSetter((Vertex)elm, method, args, ann, framedGraph);
        }
        if (methodName.startsWith("put")) {
            return this.handleAdder((Vertex)elm, method, args, ann, framedGraph);
        }
        if (methodName.startsWith("putAll")) {
            return this.handleAdder((Vertex)elm, method, args, ann, framedGraph);
        }
        throw new WindupException("Only get*, set*, and put* method names are supported for @" + MapInProperties.class.getSimpleName() + ", found at: " + method.getName());
    }

    private Map<String, Object> handleGetter(Vertex vertex, Method method, Object[] args, MapInProperties ann, FramedGraph<?> framedGraph) {
        if (args != null && args.length != 0) {
            throw new WindupException("Method must take zero arguments");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String prefix = this.preparePrefix(ann);
        Set keys = vertex.getPropertyKeys();
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            Object val = vertex.getProperty(key);
            if (!ann.propertyType().isAssignableFrom(val.getClass())) {
                log.warning("@InProperties is meant for Map<String," + ann.propertyType().getName() + ">, but the value was: " + val.getClass());
            }
            map.put(key.substring(prefix.length()), val);
        }
        return map;
    }

    private WindupVertexFrame handleSetter(Vertex vertex, Method method, Object[] args, MapInProperties ann, FramedGraph<?> framedGraph) {
        if (args == null || args.length != 1) {
            throw new WindupException("Method must take one argument: " + method.getName());
        }
        if (!(args[0] instanceof Map)) {
            throw new WindupException("Argument of " + method.getName() + " must be a Map, but is: " + args[0].getClass());
        }
        Map map = (Map)args[0];
        String prefix = this.preparePrefix(ann);
        Set keys = vertex.getPropertyKeys();
        Set mapKeys = map.keySet();
        for (String key : keys) {
            String subKey;
            if (!key.startsWith(prefix) || "w:winduptype".equals(key) || key.startsWith("w:")) continue;
            Object val = vertex.getProperty(key);
            if (!ann.propertyType().isAssignableFrom(val.getClass())) {
                log.warning("@InProperties is meant for Map<String," + ann.propertyType().getName() + ">, but the value was: " + val.getClass());
            }
            if (map.containsKey(subKey = key.substring(prefix.length()))) {
                vertex.setProperty(key, map.get(subKey));
                mapKeys.remove(subKey);
                continue;
            }
            vertex.removeProperty(key);
        }
        for (String key : mapKeys) {
            vertex.setProperty(prefix + key, map.get(key));
        }
        return null;
    }

    private WindupVertexFrame handleAdder(Vertex vertex, Method method, Object[] args, MapInProperties ann, FramedGraph<?> framedGraph) {
        if (args == null || args.length != 1) {
            throw new WindupException("Method must take one argument: " + method.getName());
        }
        String prefix = this.preparePrefix(ann);
        Map map = (Map)args[0];
        for (Map.Entry entry : map.entrySet()) {
            vertex.setProperty(prefix + (String)entry.getKey(), entry.getValue());
        }
        return null;
    }

    private String preparePrefix(MapInProperties ann) {
        return "".equals(ann.propertyPrefix()) ? "" : ann.propertyPrefix() + ':';
    }
}

