/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.addons;

import java.io.File;
import java.util.concurrent.Callable;
import org.jboss.forge.furnace.impl.addons.AddonRepositoryStateStrategyImpl;
import org.jboss.forge.furnace.lock.LockManager;
import org.jboss.forge.furnace.lock.LockMode;
import org.jboss.forge.furnace.util.Assert;

public abstract class AbstractFileSystemAddonRepository {
    protected final LockManager lock;
    protected final File addonDir;

    public AbstractFileSystemAddonRepository(LockManager lock, File addonDir) {
        Assert.notNull((Object)lock, (String)"LockManager must not be null.");
        Assert.notNull((Object)addonDir, (String)"Addon directory must not be null.");
        this.lock = lock;
        this.addonDir = addonDir;
    }

    protected File getRootDirectory() {
        if (!this.addonDir.exists() || !this.addonDir.isDirectory()) {
            this.lock.performLocked(LockMode.READ, (Callable)new Callable<File>(){

                @Override
                public File call() throws Exception {
                    AbstractFileSystemAddonRepository.this.addonDir.delete();
                    System.gc();
                    if (!AbstractFileSystemAddonRepository.this.addonDir.mkdirs()) {
                        throw new RuntimeException("Could not create Addon Directory [" + AbstractFileSystemAddonRepository.this.addonDir + "]");
                    }
                    return AbstractFileSystemAddonRepository.this.addonDir;
                }
            });
        }
        return this.addonDir;
    }

    public String toString() {
        return this.addonDir.getAbsolutePath();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addonDir == null ? 0 : this.addonDir.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddonRepositoryStateStrategyImpl other = (AddonRepositoryStateStrategyImpl)obj;
        return !(this.addonDir == null ? other.addonDir != null : !this.addonDir.equals(other.addonDir));
    }
}

