/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.commons.lang3.ObjectUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.PostReportGenerationPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.rules.AttachApplicationReportsToIndexRuleProvider;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=PostReportGenerationPhase.class, before={AttachApplicationReportsToIndexRuleProvider.class}, haltOnException=true)
public class CreateApplicationListReportRuleProvider
extends AbstractRuleProvider {
    public static final String APPLICATION_LIST_REPORT = "Application List";
    private static final String OUTPUT_FILENAME = "../index.html";
    public static final String TEMPLATE_PATH = "/reports/templates/application_list.ftl";
    @Inject
    private Furnace furnace;

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                CreateApplicationListReportRuleProvider.this.createIndexReport(event.getGraphContext());
            }
        });
    }

    private void createIndexReport(GraphContext context) {
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel report = applicationReportService.create();
        report.setReportPriority(1);
        report.setReportIconClass("glyphicon glyphicon-home");
        report.setReportName(APPLICATION_LIST_REPORT);
        report.setTemplatePath(TEMPLATE_PATH);
        report.setTemplateType(TemplateType.FREEMARKER);
        report.setDisplayInApplicationReportIndex(false);
        report.setReportFilename(OUTPUT_FILENAME);
        GraphService listService = new GraphService(context, WindupVertexListModel.class);
        WindupVertexListModel appsListVertex = (WindupVertexListModel)listService.create();
        HashMap<String, WindupVertexFrame> relatedData = new HashMap<String, WindupVertexFrame>();
        Iterable apps = applicationReportService.findAll();
        ArrayList<ApplicationReportModel> appsList = new ArrayList<ApplicationReportModel>();
        for (ApplicationReportModel applicationReportModel : apps) {
            if (applicationReportModel.isMainApplicationReport() == null || !applicationReportModel.isMainApplicationReport().booleanValue()) continue;
            appsList.add(applicationReportModel);
            if (!"<shared-libs>".equals(applicationReportModel.getProjectModel().getUniqueID())) continue;
            relatedData.put("sharedLibsApplicationReport", applicationReportModel);
        }
        relatedData.put("applications", appsListVertex);
        Collections.sort(appsList, new AppRootFileNameComparator());
        for (ApplicationReportModel applicationReportModel : appsList) {
            appsListVertex.addItem(applicationReportModel);
        }
        report.setRelatedResource(relatedData);
    }

    private static class AppRootFileNameComparator
    implements Comparator<ApplicationReportModel> {
        private AppRootFileNameComparator() {
        }

        @Override
        public int compare(ApplicationReportModel o1, ApplicationReportModel o2) {
            if (null == o1.getProjectModel() || null == o1.getProjectModel().getRootFileModel() || null == o1.getProjectModel().getRootFileModel().getFileName()) {
                return 1;
            }
            if (null == o2.getProjectModel() || null == o2.getProjectModel().getRootFileModel() || null == o2.getProjectModel().getRootFileModel().getFileName()) {
                return -1;
            }
            try {
                return ObjectUtils.compare((Comparable)((Object)o1.getProjectModel().getRootFileModel().getFileName()), (Comparable)((Object)o2.getProjectModel().getRootFileModel().getFileName()));
            }
            catch (Throwable ex) {
                return 0;
            }
        }
    }
}

