/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.PipeFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.reporting.category.IssueCategoryModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.service.EffortAccumulatorFunction;
import org.jboss.windup.reporting.service.MapSumEffortAccumulatorFunction;
import org.jboss.windup.reporting.service.SetMembersFilter;
import org.jboss.windup.rules.files.model.FileReferenceModel;

public class InlineHintService
extends GraphService<InlineHintModel> {
    public static final Logger LOG = Logger.getLogger(InlineHintService.class.getName());

    public InlineHintService(GraphContext context) {
        super(context, InlineHintModel.class);
    }

    public Iterable<InlineHintModel> getHintsForFileReference(FileReferenceModel reference) {
        GremlinPipeline inlineHintPipeline = new GremlinPipeline((Object)reference.asVertex());
        inlineHintPipeline.in(new String[]{"Hint:fileLocationReference"});
        inlineHintPipeline.has("w:winduptype", (Predicate)Text.CONTAINS, (Object)"Hint");
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)inlineHintPipeline, InlineHintModel.class);
    }

    public Iterable<InlineHintModel> getHintsForFile(FileModel file) {
        GremlinPipeline inlineHintPipeline = new GremlinPipeline((Object)file.asVertex());
        inlineHintPipeline.in(new String[]{"file"});
        inlineHintPipeline.has("w:winduptype", (Predicate)Text.CONTAINS, (Object)"Hint");
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)inlineHintPipeline, InlineHintModel.class);
    }

    public int getMigrationEffortPoints(FileModel fileModel) {
        GremlinPipeline inlineHintPipeline = new GremlinPipeline((Object)fileModel.asVertex());
        inlineHintPipeline.in(new String[]{"file"});
        inlineHintPipeline.has("EffortReportModelEffort", (Predicate)Compare.GREATER_THAN, (Object)0);
        inlineHintPipeline.has("w:winduptype", (Predicate)Text.CONTAINS, (Object)"Hint");
        int hintEffort = 0;
        for (Vertex v : inlineHintPipeline) {
            hintEffort += ((Integer)v.getProperty("EffortReportModelEffort")).intValue();
        }
        return hintEffort;
    }

    private Collection<Vertex> getProjectAndChildren(ProjectModel projectModel) {
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        result.add(projectModel.asVertex());
        for (ProjectModel child : projectModel.getChildProjects()) {
            result.addAll(this.getProjectAndChildren(child));
        }
        return result;
    }

    public Iterable<InlineHintModel> getHintsForProject(ProjectModel projectModel, boolean recursive) {
        Collection<Vertex> initialVertices = recursive ? this.getProjectAndChildren(projectModel) : Collections.singletonList(projectModel.asVertex());
        return this.getInlineHintModels(initialVertices);
    }

    public Iterable<InlineHintModel> getHintsForProjects(Iterable<ProjectModel> projectModels) {
        Iterable projectVertexIterable = Iterables.transform(projectModels, (Function)new Function<ProjectModel, Vertex>(){

            public Vertex apply(ProjectModel input) {
                return input.asVertex();
            }
        });
        return this.getInlineHintModels(projectVertexIterable);
    }

    private Iterable<InlineHintModel> getInlineHintModels(Iterable<Vertex> initialProjectVertices) {
        GremlinPipeline inlineHintPipeline = new GremlinPipeline(initialProjectVertices);
        inlineHintPipeline.out(new String[]{"projectModelToFile"});
        inlineHintPipeline.in(new String[]{"file"}).has("w:winduptype", (Predicate)Text.CONTAINS, (Object)"Hint");
        LinkedHashSet<InlineHintModel> results = new LinkedHashSet<InlineHintModel>();
        for (Vertex v : inlineHintPipeline) {
            results.add((InlineHintModel)this.frame(v));
        }
        return results;
    }

    public Map<Integer, Integer> getMigrationEffortByPoints(ProjectModelTraversal traversal, Set<String> includeTags, Set<String> excludeTags, boolean recursive, boolean includeZero) {
        MapSumEffortAccumulatorFunction accumulator = new MapSumEffortAccumulatorFunction(){

            public Object vertexToKey(Vertex effortReportVertex) {
                Integer migrationEffort = (Integer)effortReportVertex.getProperty("EffortReportModelEffort");
                return migrationEffort;
            }
        };
        this.getMigrationEffortDetails(traversal, includeTags, excludeTags, recursive, includeZero, accumulator);
        return accumulator.getResults();
    }

    public Map<IssueCategoryModel, Integer> getMigrationEffortBySeverity(GraphRewrite event, ProjectModelTraversal traversal, Set<String> includeTags, Set<String> excludeTags, boolean recursive) {
        MapSumEffortAccumulatorFunction<IssueCategoryModel> accumulator = new MapSumEffortAccumulatorFunction<IssueCategoryModel>(){

            @Override
            public IssueCategoryModel vertexToKey(Vertex effortReportVertex) {
                return ((InlineHintModel)InlineHintService.this.frame(effortReportVertex)).getIssueCategory();
            }
        };
        this.getMigrationEffortDetails(traversal, includeTags, excludeTags, recursive, true, accumulator);
        return accumulator.getResults();
    }

    private void getMigrationEffortDetails(ProjectModelTraversal traversal, Set<String> includeTags, Set<String> excludeTags, boolean recursive, boolean includeZero, EffortAccumulatorFunction accumulatorFunction) {
        LOG.log(Level.INFO, String.format("\n\t\t\tEFFORT H: getMigrationEffortDetails() with: %s, %srecur, %sincludeZero, %s, tags: %s, excl: %s", traversal, recursive ? "" : "!", includeZero ? "" : "!", accumulatorFunction, includeTags, excludeTags));
        Set initialVertices = traversal.getAllProjectsAsVertices(recursive);
        GremlinPipeline pipeline = new GremlinPipeline((Object)this.getGraphContext().getGraph());
        pipeline.V();
        if (!includeZero) {
            pipeline.has("EffortReportModelEffort", (Predicate)Compare.GREATER_THAN, (Object)0);
            pipeline.has("w:winduptype", (Predicate)Text.CONTAINS, (Object)"Hint");
        } else {
            pipeline.has("w:winduptype", (Object)"Hint");
        }
        pipeline.as("hint");
        pipeline.out(new String[]{"file"});
        pipeline.in(new String[]{"projectModelToFile"});
        pipeline.filter((PipeFunction)new SetMembersFilter(initialVertices));
        pipeline.back("hint");
        boolean checkTags = !includeTags.isEmpty() || !excludeTags.isEmpty();
        for (Vertex v : pipeline) {
            if (checkTags && !((InlineHintModel)this.frame(v)).matchesTags(includeTags, excludeTags)) continue;
            accumulatorFunction.accumulate(v);
        }
    }
}

