/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.tinkerpop.blueprints.Vertex;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TagSetModel;

public class TagSetService
extends GraphService<TagSetModel> {
    private static final String TAG_CACHE_KEY = TagSetService.class.getCanonicalName() + "_Cache";

    public TagSetService(GraphContext context) {
        super(context, TagSetModel.class);
    }

    private Map<Set<String>, Vertex> getCache(GraphRewrite event) {
        HashMap result = (HashMap)event.getRewriteContext().get((Object)TAG_CACHE_KEY);
        if (result == null) {
            result = new HashMap();
            event.getRewriteContext().put((Object)TAG_CACHE_KEY, result);
        }
        return result;
    }

    public TagSetModel getOrCreate(GraphRewrite event, Set<String> tags) {
        Map<Set<String>, Vertex> cache = this.getCache(event);
        Vertex vertex = cache.get(tags);
        if (vertex == null) {
            TagSetModel model = (TagSetModel)this.create();
            model.setTags(tags);
            cache.put(tags, model.asVertex());
            return model;
        }
        return (TagSetModel)this.frame(vertex);
    }
}

