/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.javaee.model.EjbBeanBaseModel;
import org.jboss.windup.rules.apps.javaee.model.EjbEntityBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.service.EjbBeanService;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ReportGenerationPhase.class, id="Create EJB Report")
public class CreateEJBReportRuleProvider
extends AbstractRuleProvider {
    public static final String TEMPLATE_EJB_REPORT = "/reports/templates/ejb.ftl";
    public static final String REPORT_DESCRIPTION = "The EJB report contains a list of EJBs found within the application.";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                for (FileModel inputPath : configurationModel.getInputPaths()) {
                    ProjectModel application = inputPath.getProjectModel();
                    CreateEJBReportRuleProvider.this.createEJBReport(event.getGraphContext(), application);
                }
            }

            public String toString() {
                return "CreateEJBReport";
            }
        });
    }

    private void createEJBReport(GraphContext context, ProjectModel application) {
        EjbBeanService ejbService = new EjbBeanService(context);
        GraphService listService = new GraphService(context, WindupVertexListModel.class);
        WindupVertexListModel entityList = (WindupVertexListModel)listService.create();
        WindupVertexListModel mdbList = (WindupVertexListModel)listService.create();
        WindupVertexListModel statelessList = (WindupVertexListModel)listService.create();
        WindupVertexListModel statefulList = (WindupVertexListModel)listService.create();
        boolean itemAdded = false;
        for (EjbBeanBaseModel ejbModel : ejbService.findAll()) {
            if (!Iterables.contains(ejbModel.getApplications(), (Object)application)) continue;
            itemAdded = true;
            if (ejbModel instanceof EjbMessageDrivenModel) {
                mdbList.addItem((WindupVertexFrame)ejbModel);
                continue;
            }
            if (ejbModel instanceof EjbEntityBeanModel) {
                entityList.addItem((WindupVertexFrame)ejbModel);
                continue;
            }
            if ("stateful".equalsIgnoreCase(ejbModel.getSessionType())) {
                statefulList.addItem((WindupVertexFrame)ejbModel);
                continue;
            }
            statelessList.addItem((WindupVertexFrame)ejbModel);
        }
        if (!itemAdded) {
            return;
        }
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel applicationReportModel = applicationReportService.create();
        applicationReportModel.setReportPriority(300);
        applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        applicationReportModel.setReportName("EJBs");
        applicationReportModel.setDescription(REPORT_DESCRIPTION);
        applicationReportModel.setReportIconClass("glyphicon ejb-nav-logo");
        applicationReportModel.setProjectModel(application);
        applicationReportModel.setTemplatePath(TEMPLATE_EJB_REPORT);
        applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
        HashMap<String, WindupVertexListModel> data = new HashMap<String, WindupVertexListModel>(4);
        data.put("entity", entityList);
        data.put("mdb", mdbList);
        data.put("stateless", statelessList);
        data.put("stateful", statefulList);
        applicationReportModel.setRelatedResource(data);
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)applicationReportModel, "ejbreport_" + application.getName(), "html");
    }
}

