/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.decompiler;

import java.io.File;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.util.PathUtil;

public class DecompilerUtil {
    static File getOutputDirectoryForClass(GraphContext context, JavaClassFileModel fileModel) {
        File result;
        WindupConfigurationModel configuration = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        File inputPath = fileModel.getProjectModel().getRootProjectModel().getRootFileModel().asFile();
        if (PathUtil.isInSubDirectory((File)inputPath, (File)fileModel.asFile())) {
            String outputPath = configuration.getOutputPath().getFilePath();
            result = Paths.get(outputPath, new String[0]).resolve("classes").toFile();
        } else {
            String packageName = fileModel.getPackageName();
            if (StringUtils.isBlank((CharSequence)packageName)) {
                return fileModel.asFile().getParentFile();
            }
            String[] packageComponents = packageName.split("\\.");
            File rootFile = fileModel.asFile().getParentFile();
            for (int i = 0; i < packageComponents.length; ++i) {
                rootFile = rootFile.getParentFile();
            }
            result = rootFile;
        }
        return result;
    }
}

