/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.decompiler;

import com.thinkaurelius.titan.core.TitanGraph;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.decompiler.api.ClassDecompileRequest;
import org.jboss.windup.decompiler.api.DecompilationListener;
import org.jboss.windup.decompiler.procyon.ProcyonConfiguration;
import org.jboss.windup.decompiler.procyon.ProcyonDecompiler;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.decompiler.AbstractDecompilerOperation;
import org.jboss.windup.rules.apps.java.decompiler.DecompilerUtil;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.ProgressEstimate;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.threading.WindupExecutors;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ProcyonDecompilerOperation
extends AbstractDecompilerOperation {
    private static final Logger LOG = Logging.get(ProcyonDecompilerOperation.class);
    private static final String TECH_TAG = "Decompiled Java File";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.INFORMATIONAL;

    public void perform(GraphRewrite event, EvaluationContext context) {
        ExecutionStatistics.get().begin("ProcyonDecompilationOperation.perform");
        int threads = WindupExecutors.getDefaultThreadCount();
        LOG.info("Decompiling with " + threads + " threads");
        WindupJavaConfigurationService configurationService = new WindupJavaConfigurationService(event.getGraphContext());
        Iterable<JavaClassFileModel> allClasses = this.getFilesToDecompile(event.getGraphContext());
        ArrayList<ClassDecompileRequest> classesToDecompile = new ArrayList<ClassDecompileRequest>(10000);
        for (JavaClassFileModel classFileModel : allClasses) {
            if (!configurationService.shouldScanPackage(classFileModel.getPackageName())) continue;
            File outputDir = DecompilerUtil.getOutputDirectoryForClass(event.getGraphContext(), classFileModel);
            classesToDecompile.add(new ClassDecompileRequest(outputDir.toPath(), classFileModel.asFile().toPath(), outputDir.toPath()));
        }
        Collections.sort(classesToDecompile, new Comparator<ClassDecompileRequest>(){

            @Override
            public int compare(ClassDecompileRequest o1, ClassDecompileRequest o2) {
                return o1.getOutputDirectory().toAbsolutePath().toString().compareTo(o2.getOutputDirectory().toString());
            }
        });
        ProgressEstimate progressEstimate = new ProgressEstimate(classesToDecompile.size());
        AddDecompiledItemsToGraph addDecompiledItemsToGraph = new AddDecompiledItemsToGraph(progressEstimate, event);
        ProcyonDecompiler decompiler = new ProcyonDecompiler(new ProcyonConfiguration().setIncludeNested(false));
        decompiler.setExecutorService(WindupExecutors.newFixedThreadPool((int)threads), threads);
        decompiler.decompileClassFiles(classesToDecompile, (DecompilationListener)addDecompiledItemsToGraph);
        decompiler.close();
        ExecutionStatistics.get().end("ProcyonDecompilationOperation.perform");
    }

    private class AddDecompiledItemsToGraph
    implements DecompilationListener {
        private final ExecutorService executorService = WindupExecutors.newSingleThreadExecutor();
        private final AtomicInteger queueSize = new AtomicInteger(0);
        private final GraphRewrite event;
        private final AtomicInteger atomicInteger = new AtomicInteger(0);
        private final ProgressEstimate progressEstimate;

        private AddDecompiledItemsToGraph(ProgressEstimate progressEstimate, GraphRewrite event) {
            this.progressEstimate = progressEstimate;
            this.event = event;
        }

        public void decompilationProcessComplete() {
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    LOG.info("Performing final commit for decompilation process!");
                    ((TitanGraph)AddDecompiledItemsToGraph.this.event.getGraphContext().getGraph().getBaseGraph()).commit();
                }
            });
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Thread pool failed to complete.");
            }
        }

        public void decompilationFailed(List<String> inputPath, String message) {
            this.progressEstimate.addWork(1);
        }

        public synchronized void fileDecompiled(final List<String> inputPath, final String decompiledOutputFile) {
            Runnable saveDecompiledRunnable = new Runnable(){

                @Override
                public void run() {
                    long remainingTimeMillis;
                    AddDecompiledItemsToGraph.this.queueSize.decrementAndGet();
                    AddDecompiledItemsToGraph.this.progressEstimate.addWork(1);
                    if (AddDecompiledItemsToGraph.this.progressEstimate.getWorked() % 250 == 0 && (remainingTimeMillis = AddDecompiledItemsToGraph.this.progressEstimate.getTimeRemainingInMillis()) > 1000L) {
                        AddDecompiledItemsToGraph.this.event.ruleEvaluationProgress("Decompilation", AddDecompiledItemsToGraph.this.progressEstimate.getWorked(), AddDecompiledItemsToGraph.this.progressEstimate.getTotal(), (int)remainingTimeMillis / 1000);
                    }
                    FileService fileService = new FileService(AddDecompiledItemsToGraph.this.event.getGraphContext());
                    Path classFilePath = Paths.get((String)inputPath.get(0), new String[0]);
                    FileModel decompiledFileModel = (FileModel)fileService.getUniqueByProperty("filePath", (Object)decompiledOutputFile);
                    if (decompiledFileModel == null) {
                        FileModel parentFileModel = fileService.findByPath(Paths.get(decompiledOutputFile, new String[0]).getParent().toString());
                        if (parentFileModel == null) {
                            LinkedList<Path> lineage = new LinkedList<Path>();
                            Path parentPath = Paths.get(decompiledOutputFile, new String[0]).getParent();
                            FileModel existingParentFM = parentFileModel;
                            while (existingParentFM == null) {
                                lineage.add(0, parentPath);
                                parentPath = parentPath.getParent();
                                existingParentFM = fileService.findByPath(parentPath.toString());
                            }
                            FileModel currentParent = existingParentFM;
                            for (Path p : lineage) {
                                currentParent = fileService.createByFilePath(currentParent, p.toString());
                            }
                            parentFileModel = currentParent;
                        }
                        decompiledFileModel = fileService.createByFilePath(parentFileModel, decompiledOutputFile);
                    }
                    if (decompiledOutputFile.endsWith(".java")) {
                        if (!(decompiledFileModel instanceof JavaSourceFileModel)) {
                            decompiledFileModel = (FileModel)new GraphService(AddDecompiledItemsToGraph.this.event.getGraphContext(), JavaSourceFileModel.class).addTypeToModel((WindupVertexFrame)decompiledFileModel);
                        }
                        JavaSourceFileModel decompiledSourceFileModel = (JavaSourceFileModel)decompiledFileModel;
                        TechnologyTagService techTagService = new TechnologyTagService(AddDecompiledItemsToGraph.this.event.getGraphContext());
                        techTagService.addTagToFileModel((FileModel)decompiledSourceFileModel, ProcyonDecompilerOperation.TECH_TAG, TECH_TAG_LEVEL);
                        techTagService.removeTagFromFileModel((FileModel)decompiledSourceFileModel, "Java Source");
                        FileModel classFileModel = (FileModel)fileService.getUniqueByProperty("filePath", (Object)classFilePath.toAbsolutePath().toString());
                        if (classFileModel != null && classFileModel instanceof JavaClassFileModel) {
                            ProjectModel projectModel = classFileModel.getProjectModel();
                            if (decompiledFileModel.getProjectModel() == null || !decompiledFileModel.getProjectModel().equals(projectModel)) {
                                projectModel.addFileModel(decompiledFileModel);
                            }
                            JavaClassFileModel classModel = (JavaClassFileModel)classFileModel;
                            classModel.getJavaClass().setDecompiledSource(decompiledSourceFileModel);
                            decompiledSourceFileModel.setPackageName(classModel.getPackageName());
                            decompiledSourceFileModel.setWindupGenerated(true);
                            ProcyonDecompilerOperation.this.setupClassToJavaConnections(AddDecompiledItemsToGraph.this.event.getGraphContext(), inputPath, decompiledSourceFileModel);
                            Path rootSourcePath = PathUtil.getRootFolderForSource((Path)decompiledSourceFileModel.asFile().toPath(), (String)classModel.getPackageName());
                            if (rootSourcePath != null) {
                                FileModel rootSourceFileModel = fileService.createByFilePath(rootSourcePath.toString());
                                decompiledSourceFileModel.setRootSourceFolder(rootSourceFileModel);
                            }
                            if (classModel.getJavaClass() != null) {
                                decompiledSourceFileModel.addJavaClass(classModel.getJavaClass());
                            }
                        } else {
                            throw new WindupException("Failed to find original JavaClassFileModel for decompiled Java file: " + decompiledOutputFile + " at: " + classFilePath.toString());
                        }
                    }
                    if (AddDecompiledItemsToGraph.this.atomicInteger.incrementAndGet() % 100 == 0) {
                        LOG.info("Performing periodic commit (" + AddDecompiledItemsToGraph.this.atomicInteger.get() + ")");
                        ((TitanGraph)AddDecompiledItemsToGraph.this.event.getGraphContext().getGraph().getBaseGraph()).commit();
                    }
                }
            };
            this.queueSize.incrementAndGet();
            this.executorService.submit(saveDecompiledRunnable);
            while (this.queueSize.get() > 1000) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public String toString() {
            return "DecompileWithProcyon";
        }
    }
}

