/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.rules;

import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ReportGenerationPhase.class)
public class CreateReportIndexRuleProvider
extends AbstractRuleProvider {
    public static final String REPORT_INDEX = "Report Index";
    public static final String TEMPLATE = "/reports/templates/report_index.ftl";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel configuration = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                for (FileModel inputPath : configuration.getInputPaths()) {
                    CreateReportIndexRuleProvider.this.createReportIndex(event.getGraphContext(), inputPath.getProjectModel());
                }
            }
        });
    }

    private void createReportIndex(GraphContext context, ProjectModel projectModel) {
        ApplicationReportService service = new ApplicationReportService(context);
        ApplicationReportModel applicationReportModel = service.create();
        applicationReportModel.setReportPriority(100);
        applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        applicationReportModel.setReportName(REPORT_INDEX);
        applicationReportModel.setReportIconClass("glyphicon glyphicon-th-list");
        applicationReportModel.setMainApplicationReport(Boolean.valueOf(true));
        applicationReportModel.setTemplatePath(TEMPLATE);
        applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
        applicationReportModel.setProjectModel(projectModel);
        applicationReportModel.setDescription("This report provides summary information about findings from the migration analysis, as well as links to additional reports with detailed information.");
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)applicationReportModel, "report_index_" + projectModel.getName(), "html");
    }
}

