/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.rules;

import java.util.ArrayList;
import java.util.List;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.java.reporting.rules.UnparsablesAppReportModel;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ReportGenerationPhase.class)
public class CreateUnparsableFilesReportRuleProvider
extends AbstractRuleProvider {
    public static final String REPORT_NAME = "Unparsable";
    public static final String TEMPLATE_UNPARSABLE = "/reports/templates/unparsable_files.ftl";
    public static final String DESCRIPTION = "This report shows all files that Windup could not parse in the expected format.\n                        For instance, a file with a <code>.xml</code> or <code>.wsdl</code> suffix\n                        is assumed to be an XML file. If the XML parser fails on it, you'll see that here.\n                        Besides that, the information about parsing failure is also present wherever the individual file is listed.";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        GraphOperation createReportModel = new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel windupConfiguration = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                for (FileModel fileModel : windupConfiguration.getInputPaths()) {
                    ProjectModel application = fileModel.getProjectModel();
                    if (application == null) {
                        throw new WindupException("Error, no project found in: " + fileModel.getFilePath());
                    }
                    CreateUnparsableFilesReportRuleProvider.this.createReportModel(event.getGraphContext(), application);
                }
            }

            public String toString() {
                return "addReport";
            }
        };
        return ConfigurationBuilder.begin().addRule().perform((Operation)createReportModel);
    }

    private List<ProjectModel> getProjectsWithUnparsableFiles(ProjectModelTraversal traversal) {
        ArrayList<ProjectModel> results = new ArrayList<ProjectModel>();
        for (FileModel fileModel : traversal.getCanonicalProject().getUnparsableFiles()) {
            if (fileModel.getOnParseError() == FileModel.OnParseError.IGNORE) continue;
            results.add(traversal.getCanonicalProject());
            break;
        }
        for (ProjectModelTraversal child : traversal.getChildren()) {
            results.addAll(this.getProjectsWithUnparsableFiles(child));
        }
        return results;
    }

    private void createReportModel(GraphContext context, ProjectModel application) {
        ProjectModelTraversal traversal = new ProjectModelTraversal(application);
        List<ProjectModel> projects = this.getProjectsWithUnparsableFiles(traversal);
        if (projects.isEmpty()) {
            return;
        }
        GraphService service = new GraphService(context, UnparsablesAppReportModel.class);
        UnparsablesAppReportModel reportModel = (UnparsablesAppReportModel)service.create();
        reportModel.setReportPriority(120);
        reportModel.setDisplayInApplicationReportIndex(true);
        reportModel.setReportName(REPORT_NAME);
        reportModel.setDescription(DESCRIPTION);
        reportModel.setReportIconClass("glyphicon glyphicon-warning-sign");
        reportModel.setMainApplicationReport(false);
        reportModel.setProjectModel(application);
        reportModel.setTemplatePath(TEMPLATE_UNPARSABLE);
        reportModel.setTemplateType(TemplateType.FREEMARKER);
        reportModel.setAllSubProjects(projects);
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)reportModel, "Unparsable_" + application.getName(), "html");
    }
}

