/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.ArchiveMetadataExtractionPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.LicenseModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ArchiveMetadataExtractionPhase.class, perform="DiscoverArchiveLicenseFiles")
public class DiscoverArchiveLicenseFilesRuleProvider
extends IteratingRuleProvider<ArchiveModel> {
    private static final Logger LOG = Logging.get(DiscoverArchiveLicenseFilesRuleProvider.class);
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.INFORMATIONAL;

    public ConditionBuilder when() {
        return Query.fromType(ArchiveModel.class);
    }

    public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
        Rule rule = (Rule)context.get(Rule.class);
        Set<FileModel> licenseFiles = this.findLicense(payload);
        if (licenseFiles.isEmpty()) {
            return;
        }
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        GraphService licenseService = new GraphService(event.getGraphContext(), LicenseModel.class);
        for (FileModel license : licenseFiles) {
            LOG.info("Classifying: " + license.getFileName() + " as License within archive: " + payload.getArchiveName());
            try {
                InputStream stream = license.asInputStream();
                Throwable throwable = null;
                try {
                    String content = IOUtils.toString((InputStream)stream);
                    if (StringUtils.containsIgnoreCase((CharSequence)content, (CharSequence)"Apache License, Version 2.0")) {
                        this.tagLicenseByTechnologyTag(rule, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "Apache License 2.0", "Apache License 2.0 File", "http://www.apache.org/licenses/LICENSE-2.0");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((CharSequence)content, (CharSequence)"Apache Software License, Version 1.1")) {
                        this.tagLicenseByTechnologyTag(rule, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "Apache License 1.1", "Apache License 1.1 File", "http://www.apache.org/licenses/LICENSE-1.1");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((CharSequence)content, (CharSequence)"Copyright (c) 1995-1999 The Apache Group.  All rights reserved.")) {
                        this.tagLicenseByTechnologyTag(rule, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "Apache License 1.0", "Apache License 1.0 File", "http://www.apache.org/licenses/LICENSE-1.0");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((CharSequence)content, (CharSequence)"GNU General Public License")) {
                        this.tagLicenseByTechnologyTag(rule, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "GNU GPL", "GNU General Public License File", "http://opensource.org/licenses/gpl-license");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((CharSequence)content, (CharSequence)"The MIT License (MIT)")) {
                        this.tagLicenseByTechnologyTag(rule, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "MIT License", "GNU General Public License File", "http://opensource.org/licenses/MIT");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((CharSequence)content, (CharSequence)"Mozilla Public License, version 2.0")) {
                        this.tagLicenseByTechnologyTag(rule, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "Mozilla Public License 2.0", "Mozilla Public License 2.0 File", "http://opensource.org/licenses/MPL-2.0");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((CharSequence)content, (CharSequence)"GNU Lesser General Public License")) {
                        this.tagLicenseByTechnologyTag(rule, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "GNU LGPL", "GNU LGPL File", "http://opensource.org/licenses/lgpl-license");
                        continue;
                    }
                    if (StringUtils.contains((CharSequence)content, (CharSequence)"COMMON DEVELOPMENT AND DISTRIBUTION LICENSE")) {
                        this.tagLicenseByTechnologyTag(rule, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "CDDL", "CDDL License File", "http://opensource.org/licenses/CDDL-1.0");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((CharSequence)content, (CharSequence)"Eclipse Public License")) {
                        this.tagLicenseByTechnologyTag(rule, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "Eclipse Public License 1.0", "Eclipse Public License 1.0 File", "http://opensource.org/licenses/EPL-1.0");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((CharSequence)content, (CharSequence)"Redistribution and use in source and binary forms")) {
                        this.tagLicenseByTechnologyTag(rule, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "BSD License", "BSD License File", "http://opensource.org/licenses/");
                        continue;
                    }
                    if (StringUtils.containsIgnoreCase((CharSequence)content, (CharSequence)"the work of authorship identified is in the public domain of the country")) {
                        this.tagLicenseByTechnologyTag(rule, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "Public Domain License", "Creative Commons Public Domain License File", "http://creativecommons.org/licenses/publicdomain/");
                        continue;
                    }
                    LOG.warning("Must be unknown license type: " + license.getFileName());
                    this.tagLicenseByTechnologyTag(rule, (GraphService<LicenseModel>)licenseService, technologyTagService, license, "Unknown License", "Unknown License File", "Unknown License File");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException e) {
                LOG.fine("Error while opening License file: " + license.getFileName() + " with error: " + e.getLocalizedMessage());
            }
        }
    }

    private void tagLicenseByTechnologyTag(Rule rule, GraphService<LicenseModel> licenseService, TechnologyTagService technologyTagService, FileModel license, String name, String description, String url) {
        LOG.info("Identified: " + license.getFileName() + " as: " + name);
        LicenseModel model = (LicenseModel)licenseService.addTypeToModel((WindupVertexFrame)license);
        model.setName(name);
        model.setURL(url);
        model.setGenerateSourceReport(true);
        technologyTagService.addTagToFileModel(license, name, TECH_TAG_LEVEL);
    }

    private Set<FileModel> findLicense(ArchiveModel archive) {
        HashSet<FileModel> licenses = new HashSet<FileModel>();
        Iterable files = archive.getAllFiles();
        for (FileModel model : files) {
            if (model.isDirectory()) continue;
            String fileName = model.getFileName();
            if (!(fileName = StringUtils.lowerCase((String)fileName)).endsWith("license.txt") && !fileName.endsWith("license") && !fileName.endsWith("gpl.txt") && !fileName.endsWith("lgpl.txt") && !fileName.endsWith("notice.txt") && !fileName.endsWith("notice")) continue;
            licenses.add(model);
        }
        return licenses;
    }
}

