/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.DiscoverProjectStructurePhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.ProjectService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.rules.apps.java.scan.provider.DiscoverNonMavenArchiveProjectsRuleProvider;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=DiscoverProjectStructurePhase.class, after={DiscoverNonMavenArchiveProjectsRuleProvider.class})
public class DiscoverNonMavenSourceProjectsRuleProvider
extends AbstractRuleProvider {
    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new AddProjectInformation());
    }

    public String toString() {
        return "AddProjectInformation";
    }

    private class AddProjectInformation
    extends GraphOperation {
        private AddProjectInformation() {
        }

        public void perform(GraphRewrite event, EvaluationContext context) {
            WindupConfigurationModel configuration = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
            for (FileModel mainFileModel : configuration.getInputPaths()) {
                ProjectService projectModelService = new ProjectService(event.getGraphContext());
                ProjectModel mainProjectModel = mainFileModel.getProjectModel();
                if (mainProjectModel == null) {
                    mainProjectModel = (ProjectModel)projectModelService.create();
                    mainProjectModel.setName(mainFileModel.getFileName());
                    mainProjectModel.setDescription("Source Directory");
                    mainProjectModel.setRootFileModel(mainFileModel);
                    mainProjectModel.addFileModel(mainFileModel);
                }
                this.addProjectToChildFiles(mainFileModel, mainProjectModel);
            }
        }

        private void addProjectToChildFiles(FileModel fileModel, ProjectModel projectModel) {
            for (FileModel childFile : fileModel.getFilesInDirectory()) {
                if (childFile.getProjectModel() == null) {
                    projectModel.addFileModel(childFile);
                } else if (childFile.getProjectModel().getParentProject() == null && !childFile.getProjectModel().equals(projectModel)) {
                    childFile.getProjectModel().setParentProject(projectModel);
                }
                this.addProjectToChildFiles(childFile, projectModel);
            }
        }

        public String toString() {
            return "ScanAsNonMavenProject";
        }
    }
}

