/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.rules.apps.java.condition.JavaClass;
import org.jboss.windup.rules.apps.java.condition.JavaClassBuilder;
import org.jboss.windup.rules.apps.java.condition.JavaClassBuilderAt;
import org.jboss.windup.rules.apps.java.condition.annotation.AnnotationCondition;
import org.jboss.windup.rules.apps.java.condition.annotation.AnnotationTypeCondition;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="javaclass", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class JavaClassHandler
implements ElementHandler<JavaClassBuilderAt> {
    public static final String ELEM_NAME = "javaclass";
    private static final String ATTR_REFERENCES = "references";

    public JavaClassBuilderAt processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String namePattern;
        String type = JOOX.$((Element)element).attr(ATTR_REFERENCES);
        String as = JOOX.$((Element)element).attr("as");
        String from = JOOX.$((Element)element).attr("from");
        String matchesSource = JOOX.$((Element)element).attr("matchesSource");
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new WindupException("The 'javaclass' element must have a non-empty 'references' attribute");
        }
        ArrayList<TypeReferenceLocation> locations = new ArrayList<TypeReferenceLocation>();
        List children = JOOX.$((Element)element).children().get();
        HashMap<String, AnnotationCondition> conditionMap = new HashMap<String, AnnotationCondition>();
        ArrayList<AnnotationTypeCondition> additionalAnnotationConditions = new ArrayList<AnnotationTypeCondition>();
        for (Element child : children) {
            switch (child.getNodeName()) {
                case "location": {
                    TypeReferenceLocation location = (TypeReferenceLocation)handlerManager.processElement(child);
                    locations.add(location);
                    break;
                }
                case "annotation-type": 
                case "annotation-list": 
                case "annotation-literal": {
                    String name = child.getAttribute("name");
                    AnnotationCondition annotationCondition = (AnnotationCondition)handlerManager.processElement(child);
                    if (StringUtils.isBlank((CharSequence)name)) {
                        if (!(annotationCondition instanceof AnnotationTypeCondition)) {
                            throw new WindupException("Additional Annotation Condition must be an annotation-type condition. Could it be that the 'name' property is missing?");
                        }
                        additionalAnnotationConditions.add((AnnotationTypeCondition)annotationCondition);
                        break;
                    }
                    if (conditionMap.containsKey(name)) {
                        throw new WindupException("Duplicate condition detected on annotation element: " + name);
                    }
                    conditionMap.put(name, annotationCondition);
                }
            }
        }
        JavaClassBuilder javaClassReferences = from != null ? JavaClass.from(from).references(type) : JavaClass.references(type);
        if (matchesSource != null) {
            javaClassReferences.matchesSource(matchesSource);
        }
        if (!StringUtils.isBlank((CharSequence)(namePattern = JOOX.$((Element)element).attr("in")))) {
            javaClassReferences.inType(namePattern);
        }
        JavaClassBuilderAt javaClass = javaClassReferences.at(locations.toArray(new TypeReferenceLocation[locations.size()]));
        for (Map.Entry entry : conditionMap.entrySet()) {
            javaClass.annotationMatches((String)entry.getKey(), (AnnotationCondition)entry.getValue());
        }
        for (AnnotationTypeCondition condition : additionalAnnotationConditions) {
            javaClass.annotationMatches(condition);
        }
        if (as != null) {
            javaClass.as(as);
        }
        return javaClass;
    }
}

