/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.mavenize;

import org.jboss.windup.config.AbstractConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.ValidationResult;

public class MavenizeGroupIdOption
extends AbstractConfigurationOption {
    public static final String NAME = "mavenizeGroupId";
    public static final String REGEX_GROUP_ID = "[a-zA-Z][-_a-zA-Z0-9]*(\\.[a-zA-Z][-_a-zA-Z0-9]*)*";

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return "The <groupId> to use for Maven project stub pom.xml's.";
    }

    public String getDescription() {
        return "All pom.xml files will use this value as their <groupId>. If the parameter is omitted, Windup tries to guess some value based on the application, but this guess may be wrong. Last resort default value is 'com.mycompany.mavenized'.";
    }

    public Class<?> getType() {
        return String.class;
    }

    public InputType getUIType() {
        return InputType.SINGLE;
    }

    public boolean isRequired() {
        return false;
    }

    public ValidationResult validate(Object value) {
        if (value == null) {
            return ValidationResult.SUCCESS;
        }
        if (!(value instanceof String)) {
            return new ValidationResult(ValidationResult.Level.ERROR, "mavenizeGroupId option must be a String, was: " + value.getClass().getName());
        }
        String strValue = value.toString();
        if (!strValue.matches(REGEX_GROUP_ID)) {
            return new ValidationResult(ValidationResult.Level.ERROR, "Must follow the Maven groupId format - e.g. 'com.mycompany.groupId'.");
        }
        return ValidationResult.SUCCESS;
    }
}

