/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public final class OperatingSystemUtils {
    private static boolean PRETEND_WINDOWS = Boolean.getBoolean("forge.pretend_windows");
    private static String operatingSystem = null;

    public static String getOsName() {
        if (operatingSystem == null) {
            operatingSystem = System.getProperty("os.name").toLowerCase();
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return PRETEND_WINDOWS || OperatingSystemUtils.getOsName().startsWith("windows");
    }

    public static boolean isOSX() {
        return OperatingSystemUtils.getOsName().startsWith("mac");
    }

    public static boolean isLinux() {
        return OperatingSystemUtils.getOsName().startsWith("linux");
    }

    public static File getWorkingDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static File getForgeHomeDir() {
        String property = System.getProperty("forge.home");
        return property == null ? null : new File(property).getAbsoluteFile();
    }

    public static File getUserHomeDir() {
        return new File(System.getProperty("user.home")).getAbsoluteFile();
    }

    public static String getUserHomePath() {
        return OperatingSystemUtils.getUserHomeDir().getAbsolutePath();
    }

    public static File getUserForgeDir() {
        return new File(OperatingSystemUtils.getUserHomeDir(), ".forge").getAbsoluteFile();
    }

    public static void setPretendWindows(boolean value) {
        PRETEND_WINDOWS = value;
    }

    public static String getLineSeparator() {
        return System.lineSeparator();
    }

    public static String getSafeFilename(String filename) {
        String result = filename;
        if (result != null) {
            result = result.replaceAll("[^a-zA-Z0-9]+", "-").replaceAll("^-+", "");
        }
        return result;
    }

    public static File createTempDir() throws IllegalStateException {
        File baseDir = OperatingSystemUtils.getTempDirectory();
        try {
            return Files.createTempDirectory(baseDir.toPath(), "tmpdir", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while creating temporary directory", e);
        }
    }

    public static File getTempDirectory() {
        return new File(System.getProperty("java.io.tmpdir"));
    }
}

