/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.event;

import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.util.wrappers.WrapperGraph;
import com.tinkerpop.blueprints.util.wrappers.event.EventGraph;
import com.tinkerpop.blueprints.util.wrappers.event.EventTrigger;

public class EventTransactionalGraph<T extends TransactionalGraph>
extends EventGraph<T>
implements TransactionalGraph,
WrapperGraph<T> {
    public EventTransactionalGraph(T baseGraph) {
        super(baseGraph);
        this.trigger = new EventTrigger(this, true);
    }

    @Override
    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        if (TransactionalGraph.Conclusion.SUCCESS == conclusion) {
            this.commit();
        } else {
            this.rollback();
        }
    }

    @Override
    public void commit() {
        boolean transactionFailure = false;
        try {
            ((TransactionalGraph)this.baseGraph).commit();
        }
        catch (RuntimeException re) {
            transactionFailure = true;
            throw re;
        }
        finally {
            if (!transactionFailure) {
                this.trigger.fireEventQueue();
                this.trigger.resetEventQueue();
            }
        }
    }

    @Override
    public void rollback() {
        boolean transactionFailure = false;
        try {
            ((TransactionalGraph)this.baseGraph).rollback();
        }
        catch (RuntimeException re) {
            transactionFailure = true;
            throw re;
        }
        finally {
            if (!transactionFailure) {
                this.trigger.resetEventQueue();
            }
        }
    }
}

