/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.tooling;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.jboss.windup.tooling.ExecutionResults;
import org.jboss.windup.tooling.ExecutionResultsImpl;
import org.jboss.windup.tooling.ToolingXMLService;
import org.jboss.windup.tooling.data.ClassificationImpl;
import org.jboss.windup.tooling.data.HintImpl;
import org.jboss.windup.tooling.data.IssueCategoryImpl;
import org.jboss.windup.tooling.data.LinkImpl;
import org.jboss.windup.tooling.data.QuickfixImpl;
import org.jboss.windup.tooling.data.ReportLinkImpl;
import org.jboss.windup.util.exception.WindupException;

public class DefaultToolingXMLService
implements ToolingXMLService {
    private static final long serialVersionUID = 1L;

    public void serializeResults(ExecutionResults results, OutputStream outputStream) {
        try {
            JAXBContext jaxbContext = this.getJAXBContext();
            jaxbContext.createMarshaller().marshal((Object)results, outputStream);
        }
        catch (JAXBException e) {
            throw new WindupException("Error serializing results due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public void generateSchema(final Path outputPath) {
        try {
            JAXBContext jaxbContext = this.getJAXBContext();
            SchemaOutputResolver sor = new SchemaOutputResolver(){

                public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                    StreamResult result = new StreamResult();
                    result.setSystemId(outputPath.toUri().toString());
                    return result;
                }
            };
            jaxbContext.generateSchema(sor);
        }
        catch (IOException | JAXBException e) {
            throw new WindupException("Error generating Windup schema due to: " + e.getMessage(), e);
        }
    }

    private JAXBContext getJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{ExecutionResultsImpl.class, ClassificationImpl.class, HintImpl.class, LinkImpl.class, QuickfixImpl.class, ReportLinkImpl.class, IssueCategoryImpl.class});
    }
}

