/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.tooling;

import java.rmi.RemoteException;
import java.util.logging.LogRecord;
import org.jboss.windup.exec.WindupProgressMonitor;
import org.jboss.windup.tooling.WindupToolingProgressMonitor;

public class ToolingProgressMonitorAdapter
implements WindupToolingProgressMonitor,
WindupProgressMonitor {
    private final WindupToolingProgressMonitor delegate;

    public ToolingProgressMonitorAdapter(WindupToolingProgressMonitor delegate) {
        this.delegate = delegate;
    }

    public void logMessage(LogRecord logRecord) {
        try {
            this.delegate.logMessage(logRecord);
        }
        catch (RemoteException e) {
            this.log("logMessage", e);
        }
    }

    public void beginTask(String name, int totalWork) {
        try {
            this.delegate.beginTask(name, totalWork);
        }
        catch (RemoteException e) {
            this.log("beginTask", e);
        }
    }

    public void done() {
        try {
            this.delegate.done();
        }
        catch (RemoteException e) {
            this.log("done", e);
        }
    }

    public boolean isCancelled() {
        try {
            return this.delegate.isCancelled();
        }
        catch (RemoteException e) {
            this.log("isCancelled", e);
            return true;
        }
    }

    public void setCancelled(boolean value) {
        try {
            this.delegate.setCancelled(value);
        }
        catch (RemoteException e) {
            this.log("setCancelled", e);
        }
    }

    public void setTaskName(String name) {
        try {
            this.delegate.setTaskName(name);
        }
        catch (RemoteException e) {
            this.log("setTaskName", e);
        }
    }

    public void subTask(String name) {
        try {
            this.delegate.subTask(name);
        }
        catch (RemoteException e) {
            this.log("subTask", e);
        }
    }

    public void worked(int work) {
        try {
            this.delegate.worked(work);
        }
        catch (RemoteException e) {
            this.log("worked", e);
        }
    }

    private void log(String method, RemoteException e) {
        String msg = String.format("ToolingProgressMonitorAdapter:: Failed on '%s' due to: %s", method, e.getMessage());
        System.out.println(msg);
    }
}

