/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.manager.maven;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;

public class ClasspathWorkspaceReader
implements WorkspaceReader {
    private static final Logger log = Logger.getLogger(ClasspathWorkspaceReader.class.getName());
    private static final String CLASS_PATH_KEY = "java.class.path";
    private static final String SUREFIRE_CLASS_PATH_KEY = "surefire.test.class.path";
    private final Set<String> classPathEntries = new LinkedHashSet<String>();
    private final Map<String, File> classpathFileInfoCache = new HashMap<String, File>();
    private final Map<File, File> pomFileInfoCache = new HashMap<File, File>();
    private final Map<Artifact, List<String>> foundVersionsCache = new HashMap<Artifact, List<String>>();
    private final Map<Artifact, File> foundFileCache = new HashMap<Artifact, File>();
    private final Map<File, Artifact> foundArtifactCache = new HashMap<File, Artifact>();
    private final Map<File, List<File>> foundModulesCache = new HashMap<File, List<File>>();
    private WorkspaceRepository repository = new WorkspaceRepository("classpath");

    public ClasspathWorkspaceReader() {
        String classPath = System.getProperty(CLASS_PATH_KEY);
        String surefireClassPath = System.getProperty(SUREFIRE_CLASS_PATH_KEY);
        this.classPathEntries.addAll(this.getClassPathEntries(surefireClassPath));
        this.classPathEntries.addAll(this.getClassPathEntries(classPath));
    }

    public WorkspaceRepository getRepository() {
        return this.repository;
    }

    public File findArtifact(Artifact artifact) {
        File result = this.foundFileCache.get(artifact);
        if (result == null) {
            result = this._findArtifact(artifact);
            this.foundFileCache.put(artifact, result);
        }
        return result;
    }

    public File _findArtifact(Artifact artifact) {
        File pomFile;
        File file;
        for (String classpathEntry : this.classPathEntries) {
            Artifact foundArtifact;
            File pomFile2;
            file = this.getClasspathFile(classpathEntry);
            if (file.isDirectory()) {
                Artifact foundArtifact2;
                pomFile = this.getPomFile(file);
                if (!pomFile.isFile() || !(foundArtifact2 = this.getFoundArtifact(pomFile)).getGroupId().equals(artifact.getGroupId()) || !foundArtifact2.getArtifactId().equals(artifact.getArtifactId()) || !foundArtifact2.getBaseVersion().equals(artifact.getBaseVersion())) continue;
                if ("pom".equals(artifact.getExtension())) {
                    return pomFile;
                }
                return new File(file.getParentFile(), "classes");
            }
            if (!file.isFile()) continue;
            StringBuilder name = new StringBuilder(artifact.getArtifactId()).append("-").append(artifact.getBaseVersion());
            if (!file.getName().contains(name.toString())) continue;
            if ("pom".equals(artifact.getExtension()) && (pomFile2 = new File(file.getParentFile().getParentFile(), "pom.xml")).isFile() && (foundArtifact = this.getFoundArtifact(pomFile2)).getGroupId().equals(artifact.getGroupId()) && foundArtifact.getArtifactId().equals(artifact.getArtifactId()) && foundArtifact.getBaseVersion().equals(artifact.getBaseVersion())) {
                return pomFile2;
            }
            String classifier = artifact.getClassifier();
            if (classifier != null && !classifier.isEmpty()) {
                name.append("-").append(classifier);
            }
            name.append(".").append(artifact.getExtension());
            if (!file.getName().equals(name.toString())) continue;
            return file;
        }
        for (String classpathEntry : this.classPathEntries) {
            file = this.getClasspathFile(classpathEntry);
            if (!file.isDirectory() || !(pomFile = this.getPomFile(file)).isFile()) continue;
            for (File module : this.getFoundModules(pomFile)) {
                Artifact foundArtifact;
                File modulePom = new File(module, "pom.xml");
                if (!modulePom.isFile() || !(foundArtifact = this.getFoundArtifact(modulePom)).getGroupId().equals(artifact.getGroupId()) || !foundArtifact.getArtifactId().equals(artifact.getArtifactId()) || !foundArtifact.getBaseVersion().equals(artifact.getBaseVersion())) continue;
                if ("pom".equals(artifact.getExtension())) {
                    return modulePom;
                }
                return new File(modulePom.getParentFile(), "target/classes");
            }
        }
        return null;
    }

    public List<String> findVersions(Artifact artifact) {
        List<String> result = this.foundVersionsCache.get(artifact);
        if (result == null) {
            result = this._findVersions(artifact);
            this.foundVersionsCache.put(artifact, result);
        }
        return result;
    }

    public List<String> _findVersions(Artifact artifact) {
        TreeSet<String> versions = new TreeSet<String>();
        for (String classpathEntry : this.classPathEntries) {
            Artifact foundArtifact;
            File pomFile;
            File file = this.getClasspathFile(classpathEntry);
            if (file.isDirectory()) {
                Artifact foundArtifact2;
                File pomFile2 = this.getPomFile(file);
                if (!pomFile2.isFile() || !(foundArtifact2 = this.getFoundArtifact(pomFile2)).getGroupId().equals(artifact.getGroupId()) || !foundArtifact2.getArtifactId().equals(artifact.getArtifactId())) continue;
                versions.add(foundArtifact2.getBaseVersion());
                continue;
            }
            if (!file.isFile()) continue;
            StringBuilder name = new StringBuilder(artifact.getArtifactId()).append("-").append(artifact.getBaseVersion());
            if (!file.getName().contains(name.toString()) || !"pom".equals(artifact.getExtension()) || !(pomFile = new File(file.getParentFile().getParentFile(), "pom.xml")).isFile() || !(foundArtifact = this.getFoundArtifact(pomFile)).getGroupId().equals(artifact.getGroupId()) || !foundArtifact.getArtifactId().equals(artifact.getArtifactId())) continue;
            versions.add(foundArtifact.getBaseVersion());
        }
        return new ArrayList<String>(versions);
    }

    private Set<String> getClassPathEntries(String classPath) {
        if (classPath == null || classPath.isEmpty()) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(Arrays.asList(classPath.split(File.pathSeparator)));
    }

    private File getClasspathFile(String classpathEntry) {
        File classpathFileInfo = this.classpathFileInfoCache.get(classpathEntry);
        if (classpathFileInfo == null) {
            classpathFileInfo = new File(classpathEntry);
            this.classpathFileInfoCache.put(classpathEntry, classpathFileInfo);
        }
        return classpathFileInfo;
    }

    private File getPomFile(File childFile) {
        File pomFileInfo = this.pomFileInfoCache.get(childFile);
        if (pomFileInfo == null) {
            pomFileInfo = new File(childFile.getAbsoluteFile().getParentFile().getParentFile(), "pom.xml");
            this.pomFileInfoCache.put(childFile, pomFileInfo);
        }
        return pomFileInfo;
    }

    private Artifact getFoundArtifact(File pomFile) {
        Artifact foundArtifact = this.foundArtifactCache.get(pomFile);
        if (foundArtifact == null) {
            foundArtifact = this.createFoundArtifact(pomFile);
            this.foundArtifactCache.put(pomFile, foundArtifact);
        }
        return foundArtifact;
    }

    private Artifact createFoundArtifact(File pomFile) {
        try {
            String version;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Processing " + pomFile.getAbsolutePath() + " for classpath artifact resolution");
            }
            Xpp3Dom dom = null;
            try (FileReader reader = new FileReader(pomFile);){
                dom = Xpp3DomBuilder.build((Reader)reader);
            }
            Xpp3Dom groupIdNode = dom.getChild("groupId");
            String groupId = groupIdNode == null ? null : groupIdNode.getValue();
            String artifactId = dom.getChild("artifactId").getValue();
            Xpp3Dom packaging = dom.getChild("packaging");
            String type = packaging == null ? "jar" : packaging.getValue();
            Xpp3Dom versionNode = dom.getChild("version");
            String string = version = versionNode == null ? null : versionNode.getValue();
            if (groupId == null || groupId.isEmpty()) {
                groupId = dom.getChild("parent").getChild("groupId").getValue();
            }
            if (type == null || type.isEmpty()) {
                type = "jar";
            }
            if (version == null || version.isEmpty()) {
                version = dom.getChild("parent").getChild("version").getValue();
            }
            DefaultArtifact foundArtifact = new DefaultArtifact(groupId, artifactId, type, version);
            foundArtifact.setFile(pomFile);
            return foundArtifact;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse pom.xml: " + pomFile, e);
        }
    }

    private List<File> getFoundModules(File pomFile) {
        List<File> foundArtifacts = this.foundModulesCache.get(pomFile);
        if (foundArtifacts == null) {
            foundArtifacts = this.createFoundModules(pomFile);
            this.foundModulesCache.put(pomFile, foundArtifacts);
        }
        return foundArtifacts;
    }

    private List<File> createFoundModules(File pomFile) {
        try {
            Xpp3Dom parent;
            List<File> result = new ArrayList<File>();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Processing " + pomFile.getAbsolutePath() + " for classpath module resolution");
            }
            Xpp3Dom dom = null;
            Xpp3Dom[] xpp3DomArray = null;
            try (FileReader reader = new FileReader(pomFile);){
                dom = Xpp3DomBuilder.build((Reader)reader);
            }
            catch (Throwable object) {
                xpp3DomArray = object;
                throw object;
            }
            Xpp3Dom modules = dom.getChild("modules");
            if (modules != null) {
                for (Xpp3Dom module : modules.getChildren()) {
                    result.add(new File(pomFile.getParent(), module.getValue()));
                }
            }
            if (result.isEmpty() && (parent = dom.getChild("parent")) != null) {
                File parentPom;
                String relativePath;
                Xpp3Dom relativePathNode = parent.getChild("relativePath");
                String string = relativePath = relativePathNode == null ? "../pom.xml" : relativePathNode.getValue();
                if (relativePath != null && (parentPom = pomFile.getParentFile().toPath().resolve(relativePath).toFile()).isFile()) {
                    result = this.createFoundModules(parentPom);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse pom.xml: " + pomFile, e);
        }
    }
}

