/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.cdi.impl;

import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessProducer;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.container.cdi.impl.ImportedBeanLifecycle;
import org.jboss.forge.furnace.container.cdi.impl.ServiceLiteral;
import org.jboss.forge.furnace.container.cdi.services.ExportedInstanceInjectionPoint;
import org.jboss.forge.furnace.container.cdi.util.BeanBuilder;
import org.jboss.forge.furnace.container.cdi.util.Types;
import org.jboss.forge.furnace.util.ClassLoaders;

public class ContainerServiceExtension
implements Extension {
    private static Logger logger = Logger.getLogger(ContainerServiceExtension.class.getName());
    private final Map<Class<?>, AnnotatedType<?>> services = new HashMap();
    private final Map<InjectionPoint, Class<?>> requestedServices = new HashMap();
    private final Map<InjectionPoint, ServiceLiteral> requestedServiceLiterals = new HashMap<InjectionPoint, ServiceLiteral>();
    private Addon container;
    private Addon addon;

    public ContainerServiceExtension() {
    }

    public ContainerServiceExtension(Addon container, Addon addon) {
        this.container = container;
        this.addon = addon;
    }

    public void processRemoteServiceTypes(@Observes ProcessAnnotatedType<?> event) throws InstantiationException, IllegalAccessException {
        Class type = event.getAnnotatedType().getJavaClass();
        if (this.addon.getClassLoader().equals(type.getClassLoader()) && !this.container.getClassLoader().equals(type.getClassLoader()) && !Modifier.isAbstract(type.getModifiers()) && !Modifier.isInterface(type.getModifiers())) {
            this.services.put(event.getAnnotatedType().getJavaClass(), event.getAnnotatedType());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Addon [" + this.addon + "] requires service type [" + type.getName() + "] in ClassLoader [" + type.getClassLoader() + "]");
            }
        }
    }

    public void processRemoteInjectionPointConsumer(@Observes ProcessInjectionPoint<?, ?> event, BeanManager manager) {
        Type type;
        Annotated annotated = event.getInjectionPoint().getAnnotated();
        Class injectionPointDeclaringType = Types.toClass(event.getInjectionPoint().getMember().getDeclaringClass());
        Class<?> injectionBeanValueType = Types.toClass(annotated.getBaseType());
        Class injectionPointConsumingType = null;
        injectionPointConsumingType = event.getInjectionPoint().getBean() != null ? event.getInjectionPoint().getBean().getBeanClass() : injectionPointDeclaringType;
        if (Instance.class.isAssignableFrom(injectionBeanValueType) && (type = event.getInjectionPoint().getType()) instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            injectionBeanValueType = Types.toClass(types[0]);
        }
        if (!this.isBeanConsumerLocal(injectionPointConsumingType, injectionBeanValueType) && !ClassLoaders.containsClass((ClassLoader)this.container.getClassLoader(), injectionBeanValueType)) {
            ServiceLiteral serviceLiteral = new ServiceLiteral();
            event.setInjectionPoint((InjectionPoint)new ExportedInstanceInjectionPoint(event.getInjectionPoint(), serviceLiteral));
            this.requestedServices.put(event.getInjectionPoint(), injectionBeanValueType);
            this.requestedServiceLiterals.put(event.getInjectionPoint(), serviceLiteral);
        }
    }

    public void processProducerHooks(@Observes ProcessProducer<?, ?> event, BeanManager manager) {
        Class<?> type = Types.toClass(event.getAnnotatedMember().getJavaMember());
        if (ClassLoaders.containsClass((ClassLoader)this.addon.getClassLoader(), (String)type.getName())) {
            this.services.put(type, manager.createAnnotatedType(type));
        }
    }

    public void wireCrossContainerServices(@Observes AfterBeanDiscovery event, BeanManager manager) {
        for (Map.Entry<InjectionPoint, Class<?>> entry : this.requestedServices.entrySet()) {
            InjectionPoint injectionPoint = entry.getKey();
            Annotated annotated = injectionPoint.getAnnotated();
            Member member = injectionPoint.getMember();
            Class<?> beanClass = entry.getValue();
            Set typeClosure = annotated.getTypeClosure();
            LinkedHashSet<Type> beanTypeClosure = new LinkedHashSet<Type>();
            for (Type type : typeClosure) {
                beanTypeClosure.add(this.reifyWildcardsToObjects(type));
            }
            ImportedBeanLifecycle lifecycle = new ImportedBeanLifecycle(annotated, member, injectionPoint, manager);
            Bean<Object> serviceBean = new BeanBuilder(manager).beanClass(beanClass).types(beanTypeClosure).beanLifecycle(lifecycle).qualifiers(this.requestedServiceLiterals.get(injectionPoint)).create();
            event.addBean(serviceBean);
        }
    }

    private Type reifyWildcardsToObjects(final Type type) {
        Type[] arguments;
        if (type instanceof ParameterizedType && (arguments = ((ParameterizedType)type).getActualTypeArguments()) != null) {
            boolean modified = false;
            final Type[] reifiedArguments = new Type[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                Type argument = arguments[i];
                Object reified = argument;
                if (argument instanceof WildcardType) {
                    Type[] upperBounds;
                    if (((WildcardType)argument).getLowerBounds().length == 0 && (upperBounds = ((WildcardType)argument).getUpperBounds()).length == 1 && upperBounds[0].equals(Object.class)) {
                        reified = Object.class;
                    }
                } else {
                    reified = this.reifyWildcardsToObjects(argument);
                }
                reifiedArguments[i] = reified;
                if (reified == argument) continue;
                modified = true;
            }
            if (modified) {
                return new ParameterizedType(){

                    @Override
                    public Type getRawType() {
                        return ((ParameterizedType)type).getRawType();
                    }

                    @Override
                    public Type getOwnerType() {
                        return ((ParameterizedType)type).getOwnerType();
                    }

                    @Override
                    public Type[] getActualTypeArguments() {
                        return reifiedArguments;
                    }
                };
            }
        }
        return type;
    }

    public Set<Class<?>> getServices() {
        return this.services.keySet();
    }

    private boolean isBeanConsumerLocal(Class<?> reference, Class<?> type) {
        ClassLoader referenceLoader = reference.getClassLoader();
        ClassLoader typeLoader = type.getClassLoader();
        return referenceLoader != null && referenceLoader.equals(typeLoader);
    }
}

