/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.facets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.maven.plugins.Configuration;
import org.jboss.forge.addon.maven.plugins.ConfigurationElement;
import org.jboss.forge.addon.maven.plugins.ConfigurationElementBuilder;
import org.jboss.forge.addon.maven.plugins.MavenPlugin;
import org.jboss.forge.addon.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.resource.visit.ResourceVisit;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;

@FacetConstraint(value={MavenFacet.class, PackagingFacet.class})
public class MavenWebResourcesFacet
extends AbstractFacet<Project>
implements WebResourcesFacet {
    public DirectoryResource getWebRootDirectory() {
        MavenPlugin warPlugin;
        Configuration config;
        CoordinateBuilder mvnWarPluginDep;
        Project project = (Project)this.getFaceted();
        MavenPluginFacet mavenPluginFacet = (MavenPluginFacet)project.getFacet(MavenPluginFacet.class);
        String webappFolderName = mavenPluginFacet.hasPlugin((Coordinate)(mvnWarPluginDep = CoordinateBuilder.create((String)"org.apache.maven.plugins:maven-war-plugin"))) ? ((config = (warPlugin = mavenPluginFacet.getPlugin((Coordinate)mvnWarPluginDep)).getConfig()).hasConfigurationElement("warSourceDirectory") ? config.getConfigurationElement("warSourceDirectory").getText() : "src" + File.separator + "main" + File.separator + "webapp") : "src" + File.separator + "main" + File.separator + "webapp";
        DirectoryResource projectRoot = (DirectoryResource)project.getRoot().reify(DirectoryResource.class);
        return projectRoot.getChildDirectory(webappFolderName);
    }

    public List<DirectoryResource> getWebRootDirectories() {
        ArrayList<DirectoryResource> result = new ArrayList<DirectoryResource>();
        result.add(this.getWebRootDirectory());
        return result;
    }

    public boolean isInstalled() {
        Project project = (Project)this.getFaceted();
        String packagingType = ((PackagingFacet)project.getFacet(PackagingFacet.class)).getPackagingType();
        return packagingType.equals("war");
    }

    public boolean install() {
        if (!this.isInstalled()) {
            MavenPluginBuilder plugin;
            CoordinateBuilder mvnWarPluginDep;
            ((PackagingFacet)((Project)this.getFaceted()).getFacet(PackagingFacet.class)).setPackagingType("war");
            for (DirectoryResource folder : this.getWebRootDirectories()) {
                folder.mkdirs();
            }
            MavenPluginFacet plugins = (MavenPluginFacet)((Project)this.getFaceted()).getFacet(MavenPluginFacet.class);
            if (!plugins.hasPlugin((Coordinate)(mvnWarPluginDep = CoordinateBuilder.create().setGroupId("org.apache.maven.plugins").setArtifactId("maven-war-plugin").setVersion("2.6")))) {
                plugin = MavenPluginBuilder.create().setCoordinate((Coordinate)mvnWarPluginDep);
                plugins.addPlugin((MavenPlugin)plugin);
            } else {
                plugin = plugins.getPlugin((Coordinate)mvnWarPluginDep);
            }
            if (!plugin.getConfig().hasConfigurationElement("failOnMissingWebXml")) {
                plugin.getConfig().addConfigurationElement((ConfigurationElement)ConfigurationElementBuilder.create().setName("failOnMissingWebXml").setText("false"));
            } else {
                ConfigurationElementBuilder configElement = ConfigurationElementBuilder.createFromExisting((ConfigurationElement)plugin.getConfig().getConfigurationElement("failOnMissingWebXml"));
                plugin.getConfig().removeConfigurationElement("failOnMissingWebXml");
                plugin.getConfig().addConfigurationElement((ConfigurationElement)configElement);
            }
            plugins.removePlugin((Coordinate)mvnWarPluginDep);
            plugins.addPlugin((MavenPlugin)plugin);
        }
        return true;
    }

    public FileResource<?> getWebResource(String relativePath) {
        return (FileResource)this.getWebRootDirectory().getChild(relativePath);
    }

    public FileResource<?> createWebResource(char[] data, String relativePath) {
        FileResource file = (FileResource)this.getWebRootDirectory().getChild(relativePath);
        file.setContents(data);
        return file;
    }

    public FileResource<?> createWebResource(String data, String relativePath) {
        return this.createWebResource(data.toCharArray(), relativePath);
    }

    public void visitWebResources(ResourceVisitor visitor) {
        for (DirectoryResource root : this.getWebRootDirectories()) {
            ResourceVisit visit = new ResourceVisit((Resource)root);
            visit.perform(visitor, new ResourceFilter(){

                public boolean accept(Resource<?> resource) {
                    return resource instanceof DirectoryResource;
                }
            }, new ResourceFilter(){

                public boolean accept(Resource<?> type) {
                    return true;
                }
            });
            if (!visit.isTerminated()) continue;
            break;
        }
    }
}

