/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.maven.nexusindexer.client;

import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public interface DocTo<TargetType> {
    public static final DocTo<Artifact> ARTIFACT = new DocTo<Artifact>(){

        @Override
        public Artifact convert(Document doc) {
            return new DefaultArtifact(doc.get("groupId"), doc.get("artifactId"), doc.get("classifier"), doc.get("packaging"), doc.get("version"));
        }
    };
    public static final DocTo<String> COORD_GAVCP_TAKEOVER = new DocTo<String>(){

        @Override
        public String convert(Document doc) {
            return doc.get("coord");
        }
    };
    public static final Pattern REGEX_GAVCP = Pattern.compile("([^: ]+):([^: ]+):([^: ]+):([^: ]+):([^: ]+)");
    public static final DocTo<String> COORD_GACEV = new DocTo<String>(){

        @Override
        public String convert(Document doc) {
            return doc.get("groupId") + ':' + doc.get("artifactId") + ':' + doc.get("classifier") + ':' + doc.get("packaging") + ':' + doc.get("version");
        }
    };

    public TargetType convert(Document var1);

    public static interface Fields {
        public static final String GROUP_ID = "groupId";
        public static final String ARTIFACT_ID = "artifactId";
        public static final String PACKAGING = "packaging";
        public static final String CLASSIFIER = "classifier";
        public static final String VERSION = "version";
        public static final String SHA1 = "sha1";
        public static final String PACKAGE = "package";
        public static final String COORD_GAVCP = "coord";
    }
}

