/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.simple.lifecycle;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Assert;

public class SimpleContainer {
    private static Map<ClassLoader, ContainerEntry> started = new ConcurrentHashMap<ClassLoader, ContainerEntry>();

    public static Furnace getFurnace(ClassLoader loader) {
        Assert.notNull((Object)loader, (String)"ClassLoader must not be null");
        ContainerEntry containerEntry = started.get(loader);
        return containerEntry != null ? containerEntry.furnace : null;
    }

    public static Addon getAddon(ClassLoader loader) {
        Assert.notNull((Object)loader, (String)"ClassLoader must not be null");
        ContainerEntry containerEntry = started.get(loader);
        return containerEntry != null ? containerEntry.addon : null;
    }

    public static <T> Imported<T> getServices(ClassLoader classloader, Class<T> service) {
        Furnace furnace = SimpleContainer.getFurnace(classloader);
        if (furnace != null) {
            AddonRegistry addonRegistry = furnace.getAddonRegistry(new AddonRepository[0]);
            return addonRegistry.getServices(service);
        }
        return null;
    }

    static void start(Addon addon, Furnace furnace) {
        started.put(addon.getClassLoader(), new ContainerEntry(furnace, addon));
    }

    static void stop(Addon addon) {
        started.remove(addon.getClassLoader());
    }

    private static class ContainerEntry {
        final Furnace furnace;
        final Addon addon;

        public ContainerEntry(Furnace furnace, Addon addon) {
            this.furnace = furnace;
            this.addon = addon;
        }
    }
}

