/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.InvocationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class NestedMemberAccess {
    private boolean noSynthFlag;
    private final Map<MethodWrapper, MethodAccess> mapMethodType = new HashMap<MethodWrapper, MethodAccess>();

    public void propagateMemberAccess(ClassesProcessor.ClassNode root) {
        if (root.nested.isEmpty()) {
            return;
        }
        this.noSynthFlag = DecompilerContext.getOption("nns");
        this.computeMethodTypes(root);
        this.eliminateStaticAccess(root);
    }

    private void computeMethodTypes(ClassesProcessor.ClassNode node) {
        if (node.type == 8) {
            return;
        }
        for (ClassesProcessor.ClassNode nd : node.nested) {
            this.computeMethodTypes(nd);
        }
        for (MethodWrapper method : node.getWrapper().getMethods()) {
            this.computeMethodType(node, method);
        }
    }

    private void computeMethodType(ClassesProcessor.ClassNode node, MethodWrapper method) {
        MethodAccess type = MethodAccess.NORMAL;
        if (method.root != null) {
            DirectGraph graph = method.getOrBuildGraph();
            StructMethod mt = method.methodStruct;
            if ((this.noSynthFlag || mt.isSynthetic()) && mt.hasModifier(8) && graph.nodes.size() == 2) {
                if (graph.first.exprents.size() == 1) {
                    ExitExprent exexpr;
                    Exprent exprent = graph.first.exprents.get(0);
                    MethodDescriptor mtdesc = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                    int parcount = mtdesc.params.length;
                    Exprent exprCore = exprent;
                    if (exprent.type == 4 && (exexpr = (ExitExprent)exprent).getExitType() == 0 && exexpr.getValue() != null) {
                        exprCore = exexpr.getValue();
                    }
                    switch (exprCore.type) {
                        case 5: {
                            FieldExprent fexpr = (FieldExprent)exprCore;
                            if ((parcount != 1 || fexpr.isStatic()) && (parcount != 0 || !fexpr.isStatic()) || !fexpr.getClassname().equals(node.classStruct.qualifiedName) || !fexpr.isStatic() && (fexpr.getInstance().type != 12 || ((VarExprent)fexpr.getInstance()).getIndex() != 0)) break;
                            type = MethodAccess.FIELD_GET;
                            break;
                        }
                        case 12: {
                            if (parcount != 1 || ((VarExprent)exprCore).getIndex() == 0) break;
                            type = MethodAccess.FIELD_GET;
                            break;
                        }
                        case 6: {
                            FunctionExprent functionExprent = (FunctionExprent)exprCore;
                            if (functionExprent.getFuncType() < 32 || functionExprent.getFuncType() > 35 || functionExprent.getLstOperands().get((int)0).type != 5) break;
                            type = MethodAccess.FUNCTION;
                            break;
                        }
                        case 8: {
                            type = MethodAccess.METHOD;
                            break;
                        }
                        case 2: {
                            AssignmentExprent asexpr = (AssignmentExprent)exprCore;
                            if (asexpr.getLeft().type != 5 || asexpr.getRight().type != 12) break;
                            FieldExprent fexpras = (FieldExprent)asexpr.getLeft();
                            if ((parcount != 2 || fexpras.isStatic()) && (parcount != 1 || !fexpras.isStatic()) || !fexpras.getClassname().equals(node.classStruct.qualifiedName) || !fexpras.isStatic() && (fexpras.getInstance().type != 12 || ((VarExprent)fexpras.getInstance()).getIndex() != 0) || ((VarExprent)asexpr.getRight()).getIndex() != parcount - 1) break;
                            type = MethodAccess.FIELD_SET;
                        }
                    }
                    if (type == MethodAccess.METHOD) {
                        type = MethodAccess.NORMAL;
                        InvocationExprent invexpr = (InvocationExprent)exprCore;
                        if (invexpr.isStatic() && invexpr.getLstParameters().size() == parcount || !invexpr.isStatic() && invexpr.getInstance().type == 12 && ((VarExprent)invexpr.getInstance()).getIndex() == 0 && invexpr.getLstParameters().size() == parcount - 1) {
                            boolean equalpars = true;
                            for (int i = 0; i < invexpr.getLstParameters().size(); ++i) {
                                Exprent parexpr = invexpr.getLstParameters().get(i);
                                if (parexpr.type == 12 && ((VarExprent)parexpr).getIndex() == i + (invexpr.isStatic() ? 0 : 1)) continue;
                                equalpars = false;
                                break;
                            }
                            if (equalpars) {
                                type = MethodAccess.METHOD;
                            }
                        }
                    }
                } else if (graph.first.exprents.size() == 2) {
                    Exprent exprentFirst = graph.first.exprents.get(0);
                    Exprent exprentSecond = graph.first.exprents.get(1);
                    if (exprentFirst.type == 2 && exprentSecond.type == 4) {
                        MethodDescriptor mtdesc = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                        int parcount = mtdesc.params.length;
                        AssignmentExprent asexpr = (AssignmentExprent)exprentFirst;
                        if (asexpr.getLeft().type == 5 && asexpr.getRight().type == 12) {
                            ExitExprent exexpr;
                            FieldExprent fexpras = (FieldExprent)asexpr.getLeft();
                            if ((parcount == 2 && !fexpras.isStatic() || parcount == 1 && fexpras.isStatic()) && fexpras.getClassname().equals(node.classStruct.qualifiedName) && (fexpras.isStatic() || fexpras.getInstance().type == 12 && ((VarExprent)fexpras.getInstance()).getIndex() == 0) && ((VarExprent)asexpr.getRight()).getIndex() == parcount - 1 && (exexpr = (ExitExprent)exprentSecond).getExitType() == 0 && exexpr.getValue() != null && exexpr.getValue().type == 12 && ((VarExprent)asexpr.getRight()).getIndex() == parcount - 1) {
                                type = MethodAccess.FIELD_SET;
                            }
                        }
                    }
                }
            }
        }
        if (type != MethodAccess.NORMAL) {
            this.mapMethodType.put(method, type);
        } else {
            this.mapMethodType.remove(method);
        }
    }

    private void eliminateStaticAccess(ClassesProcessor.ClassNode node) {
        if (node.type == 8) {
            return;
        }
        for (MethodWrapper meth : node.getWrapper().getMethods()) {
            if (meth.root == null) continue;
            boolean replaced = false;
            DirectGraph graph = meth.getOrBuildGraph();
            HashSet<DirectNode> setVisited = new HashSet<DirectNode>();
            LinkedList<DirectNode> stack = new LinkedList<DirectNode>();
            stack.add(graph.first);
            while (!stack.isEmpty()) {
                DirectNode nd = (DirectNode)stack.removeFirst();
                if (setVisited.contains(nd)) continue;
                setVisited.add(nd);
                for (int i = 0; i < nd.exprents.size(); ++i) {
                    Exprent ret;
                    Exprent exprent = nd.exprents.get(i);
                    replaced |= this.replaceInvocations(node, meth, exprent);
                    if (exprent.type != 8 || (ret = this.replaceAccessExprent(node, meth, (InvocationExprent)exprent)) == null) continue;
                    nd.exprents.set(i, ret);
                    replaced = true;
                }
                for (DirectNode ndx : nd.succs) {
                    stack.add(ndx);
                }
            }
            if (!replaced) continue;
            this.computeMethodType(node, meth);
        }
        for (ClassesProcessor.ClassNode child : node.nested) {
            this.eliminateStaticAccess(child);
        }
    }

    private boolean replaceInvocations(ClassesProcessor.ClassNode caller, MethodWrapper meth, Exprent exprent) {
        boolean found;
        boolean res = false;
        for (Exprent expr : exprent.getAllExprents()) {
            res |= this.replaceInvocations(caller, meth, expr);
        }
        block1: do {
            found = false;
            for (Exprent expr : exprent.getAllExprents()) {
                Exprent newexpr;
                if (expr.type != 8 || (newexpr = this.replaceAccessExprent(caller, meth, (InvocationExprent)expr)) == null) continue;
                exprent.replaceExprent(expr, newexpr);
                found = true;
                res = true;
                continue block1;
            }
        } while (found);
        return res;
    }

    private static boolean sameTree(ClassesProcessor.ClassNode caller, ClassesProcessor.ClassNode callee) {
        if (caller.classStruct.qualifiedName.equals(callee.classStruct.qualifiedName)) {
            return false;
        }
        while (caller.parent != null) {
            caller = caller.parent;
        }
        while (callee.parent != null) {
            callee = callee.parent;
        }
        return caller == callee;
    }

    private Exprent replaceAccessExprent(ClassesProcessor.ClassNode caller, MethodWrapper methdest, InvocationExprent invexpr) {
        ClassesProcessor.ClassNode node = DecompilerContext.getClassProcessor().getMapRootClasses().get(invexpr.getClassname());
        MethodWrapper methsource = null;
        if (node != null && node.getWrapper() != null) {
            methsource = node.getWrapper().getMethodWrapper(invexpr.getName(), invexpr.getStringDescriptor());
        }
        if (methsource == null || !this.mapMethodType.containsKey(methsource)) {
            return null;
        }
        if (node.classStruct.qualifiedName.equals(caller.classStruct.qualifiedName) && methsource.methodStruct.getName().equals(methdest.methodStruct.getName()) && methsource.methodStruct.getDescriptor().equals(methdest.methodStruct.getDescriptor())) {
            return null;
        }
        MethodAccess type = this.mapMethodType.get(methsource);
        if (!NestedMemberAccess.sameTree(caller, node)) {
            return null;
        }
        DirectGraph graph = methsource.getOrBuildGraph();
        Exprent source = graph.first.exprents.get(0);
        Exprent retexprent = null;
        switch (type) {
            case FIELD_GET: {
                ExitExprent exsource = (ExitExprent)source;
                if (exsource.getValue().type == 12) {
                    VarExprent var = (VarExprent)exsource.getValue();
                    String varname = methsource.varproc.getVarName(new VarVersionPair(var));
                    if (!methdest.setOuterVarNames.contains(varname)) {
                        VarNamesCollector vnc = new VarNamesCollector();
                        vnc.addName(varname);
                        methdest.varproc.refreshVarNames(vnc);
                        methdest.setOuterVarNames.add(varname);
                    }
                    int index = methdest.counter.getCounterAndIncrement(2);
                    VarExprent ret = new VarExprent(index, var.getVarType(), methdest.varproc);
                    methdest.varproc.setVarName(new VarVersionPair(index, 0), varname);
                    retexprent = ret;
                    break;
                }
                Exprent ret = (FieldExprent)exsource.getValue().copy();
                if (!((FieldExprent)ret).isStatic()) {
                    ((FieldExprent)ret).replaceExprent(((FieldExprent)ret).getInstance(), invexpr.getLstParameters().get(0));
                }
                retexprent = ret;
                break;
            }
            case FIELD_SET: {
                Exprent ret;
                if (source.type == 4) {
                    ExitExprent extex = (ExitExprent)source;
                    ret = (AssignmentExprent)extex.getValue().copy();
                } else {
                    ret = (AssignmentExprent)source.copy();
                }
                FieldExprent fexpr = (FieldExprent)((AssignmentExprent)ret).getLeft();
                if (fexpr.isStatic()) {
                    ((AssignmentExprent)ret).replaceExprent(((AssignmentExprent)ret).getRight(), invexpr.getLstParameters().get(0));
                } else {
                    ((AssignmentExprent)ret).replaceExprent(((AssignmentExprent)ret).getRight(), invexpr.getLstParameters().get(1));
                    fexpr.replaceExprent(fexpr.getInstance(), invexpr.getLstParameters().get(0));
                }
                retexprent = ret;
                break;
            }
            case FUNCTION: {
                retexprent = NestedMemberAccess.replaceFunction(invexpr, source);
                break;
            }
            case METHOD: {
                if (source.type == 4) {
                    source = ((ExitExprent)source).getValue();
                }
                InvocationExprent invret = (InvocationExprent)source.copy();
                int index = 0;
                if (!invret.isStatic()) {
                    invret.replaceExprent(invret.getInstance(), invexpr.getLstParameters().get(0));
                    index = 1;
                }
                for (int i = 0; i < invret.getLstParameters().size(); ++i) {
                    invret.replaceExprent(invret.getLstParameters().get(i), invexpr.getLstParameters().get(i + index));
                }
                retexprent = invret;
            }
        }
        if (retexprent != null) {
            StructMethod mt;
            boolean hide = true;
            if (!(node.type != 0 && (node.access & 8) == 0 || (mt = methsource.methodStruct).isSynthetic())) {
                hide = false;
            }
            if (hide) {
                node.getWrapper().getHiddenMembers().add(InterpreterUtil.makeUniqueKey(invexpr.getName(), invexpr.getStringDescriptor()));
            }
        }
        return retexprent;
    }

    private static Exprent replaceFunction(InvocationExprent invexpr, Exprent source) {
        FunctionExprent functionExprent = (FunctionExprent)((ExitExprent)source).getValue().copy();
        List<Exprent> lstParameters = invexpr.getLstParameters();
        FieldExprent fieldExprent = (FieldExprent)functionExprent.getLstOperands().get(0);
        if (fieldExprent.isStatic()) {
            if (!lstParameters.isEmpty()) {
                return null;
            }
            return functionExprent;
        }
        if (lstParameters.size() != 1) {
            return null;
        }
        fieldExprent.replaceExprent(fieldExprent.getInstance(), lstParameters.get(0));
        return functionExprent;
    }

    private static enum MethodAccess {
        NORMAL,
        FIELD_GET,
        FIELD_SET,
        METHOD,
        FUNCTION;

    }
}

