/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.lazy.LazyLoader;
import org.jetbrains.java.decompiler.util.DataInputFullStream;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class StructClass
extends StructMember {
    public final String qualifiedName;
    public final PrimitiveConstant superClass;
    private final boolean own;
    private final LazyLoader loader;
    private final int minorVersion;
    private final int majorVersion;
    private final int[] interfaces;
    private final String[] interfaceNames;
    private final VBStyleCollection<StructField, String> fields;
    private final VBStyleCollection<StructMethod, String> methods;
    private ConstantPool pool;

    public StructClass(byte[] bytes, boolean own, LazyLoader loader) throws IOException {
        this(new DataInputFullStream(bytes), own, loader);
    }

    public StructClass(DataInputFullStream in, boolean own, LazyLoader loader) throws IOException {
        int i;
        this.own = own;
        this.loader = loader;
        in.discard(4);
        this.minorVersion = in.readUnsignedShort();
        this.majorVersion = in.readUnsignedShort();
        this.pool = new ConstantPool(in);
        this.accessFlags = in.readUnsignedShort();
        int thisClassIdx = in.readUnsignedShort();
        int superClassIdx = in.readUnsignedShort();
        this.qualifiedName = this.pool.getPrimitiveConstant(thisClassIdx).getString();
        this.superClass = this.pool.getPrimitiveConstant(superClassIdx);
        int length = in.readUnsignedShort();
        this.interfaces = new int[length];
        this.interfaceNames = new String[length];
        for (i = 0; i < length; ++i) {
            this.interfaces[i] = in.readUnsignedShort();
            this.interfaceNames[i] = this.pool.getPrimitiveConstant(this.interfaces[i]).getString();
        }
        length = in.readUnsignedShort();
        this.fields = new VBStyleCollection();
        for (i = 0; i < length; ++i) {
            StructField field = new StructField(in, this);
            this.fields.addWithKey(field, InterpreterUtil.makeUniqueKey(field.getName(), field.getDescriptor()));
        }
        length = in.readUnsignedShort();
        this.methods = new VBStyleCollection();
        for (i = 0; i < length; ++i) {
            StructMethod method = new StructMethod(in, this);
            this.methods.addWithKey(method, InterpreterUtil.makeUniqueKey(method.getName(), method.getDescriptor()));
        }
        this.attributes = this.readAttributes(in, this.pool);
        this.releaseResources();
    }

    public boolean hasField(String name, String descriptor) {
        return this.getField(name, descriptor) != null;
    }

    public StructField getField(String name, String descriptor) {
        return this.fields.getWithKey(InterpreterUtil.makeUniqueKey(name, descriptor));
    }

    public StructMethod getMethod(String key) {
        return this.methods.getWithKey(key);
    }

    public StructMethod getMethod(String name, String descriptor) {
        return this.methods.getWithKey(InterpreterUtil.makeUniqueKey(name, descriptor));
    }

    public String getInterface(int i) {
        return this.interfaceNames[i];
    }

    public void releaseResources() {
        if (this.loader != null) {
            this.pool = null;
        }
    }

    public ConstantPool getPool() {
        if (this.pool == null && this.loader != null) {
            this.pool = this.loader.loadPool(this.qualifiedName);
        }
        return this.pool;
    }

    public int[] getInterfaces() {
        return this.interfaces;
    }

    public String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public VBStyleCollection<StructMethod, String> getMethods() {
        return this.methods;
    }

    public VBStyleCollection<StructField, String> getFields() {
        return this.fields;
    }

    public boolean isOwn() {
        return this.own;
    }

    public LazyLoader getLoader() {
        return this.loader;
    }

    public boolean isVersionGE_1_5() {
        return this.majorVersion > 48 || this.majorVersion == 48 && this.minorVersion > 0;
    }

    public boolean isVersionGE_1_7() {
        return this.majorVersion >= 51;
    }

    public int getBytecodeVersion() {
        switch (this.majorVersion) {
            case 53: {
                return 6;
            }
            case 52: {
                return 5;
            }
            case 51: {
                return 4;
            }
            case 50: {
                return 3;
            }
            case 49: {
                return 2;
            }
        }
        return 1;
    }
}

