/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.facets.constraints;

import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.facets.constraints.FacetConstraintType;
import org.jboss.forge.addon.facets.constraints.FacetConstraints;
import org.jboss.forge.furnace.util.Annotations;

public abstract class FacetInspector {
    public static <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> boolean isConstraintSatisfied(Faceted<FACETTYPE> faceted, Set<Class<FACETTYPE>> requiredFacets) {
        boolean constraintsSatisfied = true;
        for (Class<FACETTYPE> type : requiredFacets) {
            if (faceted.hasFacet(type)) continue;
            constraintsSatisfied = false;
            break;
        }
        return constraintsSatisfied;
    }

    public static <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> boolean hasCircularConstraints(Class<?> inspectedType) {
        Set<Class<FACETTYPE>> allRelatedFacets = FacetInspector.getAllRelatedFacets(inspectedType);
        for (Class<FACETTYPE> requirement : allRelatedFacets) {
            for (Class<FACETTYPE> subrequirement : FacetInspector.getAllRelatedFacets(requirement)) {
                if (!subrequirement.isAssignableFrom(requirement)) continue;
                return true;
            }
        }
        return false;
    }

    public static <FACETTYPE extends Facet<?>> Set<Class<FACETTYPE>> getOptionalFacets(Class<?> inspectedType) {
        return FacetInspector.getRelatedFacets(inspectedType, FacetConstraintType.OPTIONAL);
    }

    public static <FACETTYPE extends Facet<?>> Set<Class<FACETTYPE>> getRequiredFacets(Class<?> inspectedType) {
        return FacetInspector.getRelatedFacets(inspectedType, FacetConstraintType.REQUIRED);
    }

    private static <FACETTYPE extends Facet<?>> Set<Class<FACETTYPE>> getRelatedFacets(Class<?> inspectedType, FacetConstraintType ... constraintTypes) {
        FacetConstraint constraint;
        LinkedHashSet<Class<FACETTYPE>> result = new LinkedHashSet<Class<FACETTYPE>>();
        if (Annotations.isAnnotationPresent(inspectedType, FacetConstraints.class)) {
            FacetConstraints constraints = (FacetConstraints)Annotations.getAnnotation(inspectedType, FacetConstraints.class);
            for (FacetConstraint constraint2 : constraints.value()) {
                if (constraint2.value() == null || constraintTypes != null && constraintTypes.length != 0 && !FacetInspector.equalsAny(constraint2.type(), constraintTypes)) continue;
                for (Class<? extends Facet> facetType : constraint2.value()) {
                    if (!Facet.class.isAssignableFrom(facetType) || facetType.isAssignableFrom(inspectedType)) continue;
                    result.add(facetType);
                }
            }
        }
        if (Annotations.isAnnotationPresent(inspectedType, FacetConstraint.class) && (constraint = (FacetConstraint)Annotations.getAnnotation(inspectedType, FacetConstraint.class)).value() != null && (constraintTypes == null || constraintTypes.length == 0 || FacetInspector.equalsAny(constraint.type(), constraintTypes))) {
            for (Class<? extends Facet> facetType : constraint.value()) {
                if (!Facet.class.isAssignableFrom(facetType) || facetType.isAssignableFrom(inspectedType)) continue;
                result.add(facetType);
            }
        }
        return result;
    }

    private static boolean equalsAny(FacetConstraintType type, FacetConstraintType ... validTypes) {
        if (validTypes != null) {
            for (FacetConstraintType validType : validTypes) {
                if (!validType.equals((Object)type)) continue;
                return true;
            }
        }
        return false;
    }

    public static <FACETEDTYPE extends Faceted<FACETTYPE>, FACETTYPE extends Facet<FACETEDTYPE>> Set<Class<FACETTYPE>> getAllOptionalFacets(Class<FACETTYPE> inspectedType) {
        LinkedHashSet<Class<FACETTYPE>> seen = new LinkedHashSet<Class<FACETTYPE>>();
        return FacetInspector.getAllRelatedFacets(seen, inspectedType, FacetConstraintType.OPTIONAL);
    }

    public static <FACETTYPE extends Facet<?>> Set<Class<FACETTYPE>> getAllRequiredFacets(Class<?> inspectedType) {
        LinkedHashSet<Class<FACETTYPE>> seen = new LinkedHashSet<Class<FACETTYPE>>();
        return FacetInspector.getAllRelatedFacets(seen, inspectedType, FacetConstraintType.REQUIRED);
    }

    public static <FACETTYPE extends Facet<?>> Set<Class<FACETTYPE>> getAllRelatedFacets(Class<?> inspectedType) {
        LinkedHashSet<Class<FACETTYPE>> seen = new LinkedHashSet<Class<FACETTYPE>>();
        return FacetInspector.getAllRelatedFacets(seen, inspectedType, new FacetConstraintType[0]);
    }

    private static <FACETTYPE extends Facet<?>> Set<Class<FACETTYPE>> getAllRelatedFacets(Set<Class<FACETTYPE>> seen, Class<?> inspectedType, FacetConstraintType ... constraintTypes) {
        LinkedHashSet<Class<FACETTYPE>> result = new LinkedHashSet<Class<FACETTYPE>>();
        Set<Class<FACETTYPE>> related = FacetInspector.getRelatedFacets(inspectedType, constraintTypes);
        for (Class<FACETTYPE> relatedType : related) {
            if (seen.contains(relatedType)) continue;
            seen.add(relatedType);
            result.addAll(FacetInspector.getAllRelatedFacets(seen, relatedType, constraintTypes));
        }
        result.addAll(related);
        return result;
    }
}

