/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames.structures;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.structures.FramedVertexSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class FramedVertexMap<T>
implements Map<T, Object> {
    private final Map<Vertex, Object> map;
    protected final Class<T> kind;
    protected final FramedGraph<? extends Graph> framedGraph;

    public FramedVertexMap(FramedGraph<? extends Graph> framedGraph, Map<Vertex, Object> map, Class<T> kind) {
        this.framedGraph = framedGraph;
        this.map = map;
        this.kind = kind;
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Object put(T key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map otherMap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public Set<T> keySet() {
        return new FramedVertexSet<T>(this.framedGraph, this.map.keySet(), this.kind);
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<T, Object>> entrySet() {
        LinkedHashSet<Map.Entry<T, Object>> entries = new LinkedHashSet<Map.Entry<T, Object>>();
        for (Map.Entry<Vertex, Object> entry : this.map.entrySet()) {
            entries.add(new FramedEntry(entry));
        }
        return entries;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    private class FramedEntry<T>
    implements Map.Entry<T, Object> {
        private final Map.Entry<Vertex, Object> entry;

        public FramedEntry(Map.Entry<Vertex, Object> entry) {
            this.entry = entry;
        }

        @Override
        public Object setValue(Object object) {
            return this.entry.setValue(object);
        }

        @Override
        public Object getValue() {
            return this.entry.getValue();
        }

        @Override
        public T getKey() {
            return FramedVertexMap.this.framedGraph.frame(this.entry.getKey(), FramedVertexMap.this.kind);
        }
    }
}

