/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.data;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.metadata.type.archive.ArchiveMetadata;
import org.jboss.windup.reporting.Reporter;
import org.jboss.windup.reporting.data.ResourceData;
import org.jboss.windup.reporting.data.ResourceDataMarshaller;
import org.jboss.windup.reporting.transformers.MetaResultTransformResolver;
import org.jboss.windup.reporting.transformers.MetaResultTransformer;

public class ResourceDataReporter
implements Reporter {
    private static final Log LOG = LogFactory.getLog(ResourceDataReporter.class);
    private MetaResultTransformResolver resolver;
    private ResourceDataMarshaller marshaller = new ResourceDataMarshaller();

    public void setResolver(MetaResultTransformResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void process(ArchiveMetadata archive, File reportDirectory) {
        for (ArchiveMetadata archiveMeta : archive.getNestedArchives()) {
            this.process(archiveMeta, reportDirectory);
        }
        for (FileMetadata fileMeta : archive.getEntries()) {
            MetaResultTransformer<?> transformer = this.resolver.resolveTransformer(fileMeta.getClass());
            ResourceData data = transformer.toResourceData(fileMeta, reportDirectory);
            File metaOut = new File(fileMeta.getFilePointer().getAbsolutePath() + ".windup.meta");
            try {
                this.marshaller.marshal(metaOut, data);
            }
            catch (IOException e) {
                LOG.error((Object)("Exception writing meta: " + metaOut.getAbsolutePath()), (Throwable)e);
            }
        }
    }
}

