/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.html;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.metadata.type.archive.ArchiveMetadata;
import org.jboss.windup.reporting.ReportUtil;
import org.jboss.windup.reporting.Reporter;
import org.jboss.windup.reporting.html.ArchiveReport;
import org.jboss.windup.reporting.html.ClasspathReport;
import org.jboss.windup.reporting.html.ResourceReport;
import org.jboss.windup.reporting.html.writer.ClassloaderHtmlWriter;
import org.jboss.windup.reporting.html.writer.ResourceHtmlWriter;
import org.jboss.windup.reporting.html.writer.SummaryHtmlWriter;
import org.jboss.windup.reporting.transformers.ArchiveMetaTransformer;
import org.jboss.windup.reporting.transformers.MetaResultTransformResolver;
import org.jboss.windup.reporting.transformers.MetaResultTransformer;

public class StaticHtmlReporter
implements Reporter {
    private static final Log LOG = LogFactory.getLog(StaticHtmlReporter.class);
    private MetaResultTransformResolver resolver;

    public void setResolver(MetaResultTransformResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void process(ArchiveMetadata archive, File reportDirectory) {
        ArchiveReport archiveReport = this.toArchiveReport(archive, reportDirectory);
        this.writeStaticResourceReports(archiveReport, reportDirectory);
        this.writeSupportingFiles(reportDirectory);
        this.writeStaticSummaryReport(archiveReport, reportDirectory);
    }

    protected void writeSupportingFiles(File reportDirectory) {
        try {
            this.writeSupportedFile("snippet/jquery.snippet.min.js", reportDirectory);
            this.writeSupportedFile("snippet/jquery.snippet.min.css", reportDirectory);
            this.writeSupportedFile("snippet/jquery.snippet.java-manifest.js", reportDirectory);
            this.writeSupportedFile("jquery.min.js", reportDirectory);
            this.writeSupportedFile("windup.css", reportDirectory);
            this.writeSupportedFile("windup.js", reportDirectory);
            this.writeSupportedFile("img/windup-logo.png", reportDirectory);
            this.writeSupportedFile("img/rh-logo.png", reportDirectory);
            this.writeSupportedFile("flot/jquery.flot.min.js", reportDirectory);
            this.writeSupportedFile("flot/jquery.flot.pie.min.js", reportDirectory);
            this.writeSupportedFile("jquery-ui/jquery.ui.widget.js", reportDirectory);
            this.writeSupportedFile("sausage/jquery.sausage.min.js", reportDirectory);
            this.writeSupportedFile("sausage/sausage.css", reportDirectory);
            this.writeSupportedFile("img/styles/glyphicons_195_circle_info.png", reportDirectory);
            this.writeSupportedFile("img/styles/glyphicons_196_circle_exclamation_mark.png", reportDirectory);
            this.writeSupportedFile("img/styles/glyphicons_217_circle_arrow_right.png", reportDirectory);
            this.writeSupportedFile("img/favicon.png", reportDirectory);
            this.writeSupportedFile("jquery-collapse/jquery.collapse.js", reportDirectory);
            this.writeSupportedFile("jquery-collapse/jquery.collapse_storage.js", reportDirectory);
            this.writeSupportedFile("jquery-collapse/jquery.collapse_cookie_storage.js", reportDirectory);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception writing supporting file.", (Throwable)e);
        }
    }

    protected void writeSupportedFile(String fileName, File reportDirectory) throws IOException {
        String resourcePath = "supporting/" + fileName;
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
        if (in != null) {
            fileName = StringUtils.replace((String)fileName, (String)"/", (String)File.separator);
            File file = new File(reportDirectory + File.separator + fileName);
            File dirFile = new File(StringUtils.substringBeforeLast((String)file.getAbsolutePath(), (String)File.separator));
            FileUtils.forceMkdir((File)dirFile);
            IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(file));
        } else {
            LOG.warn((Object)("Could not find resource: " + resourcePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeStaticSummaryReport(ArchiveReport archive, File reportDirectory) {
        SummaryHtmlWriter writer = new SummaryHtmlWriter();
        File report = new File(reportDirectory.getAbsoluteFile() + File.separator + "index.html");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Report: " + report.getAbsolutePath()));
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(report);
            writer.writeStatic(fw, archive);
        }
        catch (IOException e) {
            try {
                LOG.error((Object)"Exception writing overview.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fw);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fw);
        }
        IOUtils.closeQuietly((Writer)fw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeStaticResourceReports(ArchiveReport archive, File reportDirectory) {
        String relativePath;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Recursing ArchiveMetadata: " + archive.getRelativePathFromRoot()));
        }
        for (ArchiveReport report : archive.getNestedArchiveReports()) {
            this.writeStaticResourceReports(report, reportDirectory);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing ArchiveMetadata: " + archive.getRelativePathFromRoot()));
        }
        for (ResourceReport resourceReport : archive.getAdditionalInformationReports()) {
            LOG.debug((Object)("Generating additional report: " + resourceReport.getClass()));
            if (!(resourceReport instanceof ClasspathReport)) continue;
            ClasspathReport cpr = (ClasspathReport)resourceReport;
            ClassloaderHtmlWriter writer = new ClassloaderHtmlWriter();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Report Directory: " + reportDirectory.getAbsoluteFile()));
                LOG.debug((Object)("Relative Path: " + resourceReport.getRelativePathFromRoot()));
            }
            String filePath = reportDirectory.getAbsoluteFile() + File.separator + "CLASSLOADER";
            String htmlPath = filePath + ".html";
            cpr.setRelativePathToRoot("./");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("File Path: " + filePath));
                LOG.debug((Object)("HTML Path: " + htmlPath));
            }
            File html = new File(htmlPath);
            FileWriter resourceReportFile = null;
            try {
                resourceReportFile = new FileWriter(html);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Writing Report: " + htmlPath));
                }
                writer.writeStatic(resourceReportFile, cpr);
                relativePath = ReportUtil.calculateRelativePathFromRoot(reportDirectory, html);
                resourceReport.setRelativePathFromRootToReport(relativePath);
            }
            catch (IOException e1) {
                try {
                    LOG.error((Object)("Exception writing: " + html.getAbsolutePath()), (Throwable)e1);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(resourceReportFile);
                    throw throwable;
                }
                IOUtils.closeQuietly((Writer)resourceReportFile);
                continue;
            }
            IOUtils.closeQuietly((Writer)resourceReportFile);
        }
        for (ResourceReport resourceReport : archive.getResourceReports()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Report Directory: " + reportDirectory.getAbsoluteFile()));
                LOG.debug((Object)("Relative Path: " + resourceReport.getRelativePathFromRoot()));
            }
            String filePath = reportDirectory.getAbsoluteFile() + File.separator + resourceReport.getRelativePathFromRoot();
            String htmlPath = filePath + ".html";
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("File Path: " + filePath));
                LOG.debug((Object)("HTML Path: " + htmlPath));
            }
            File html = new File(htmlPath);
            FileWriter resourceReportFile = null;
            try {
                resourceReportFile = new FileWriter(html);
                ResourceHtmlWriter writer = new ResourceHtmlWriter();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Writing Report: " + htmlPath));
                }
                String sourceText = FileUtils.readFileToString((File)new File(filePath));
                writer.writeStatic(resourceReportFile, sourceText, resourceReport);
                relativePath = ReportUtil.calculateRelativePathFromRoot(reportDirectory, html);
                resourceReport.setRelativePathFromRootToReport(relativePath);
            }
            catch (IOException e1) {
                try {
                    LOG.error((Object)("Exception writing: " + html.getAbsolutePath()), (Throwable)e1);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(resourceReportFile);
                    throw throwable;
                }
                IOUtils.closeQuietly((Writer)resourceReportFile);
                continue;
            }
            IOUtils.closeQuietly((Writer)resourceReportFile);
        }
    }

    protected ArchiveReport toArchiveReport(ArchiveMetadata archive, File reportDirectory) {
        ArchiveMetaTransformer fmt = new ArchiveMetaTransformer();
        ArchiveReport report = (ArchiveReport)fmt.toResourceReport((FileMetadata)archive, reportDirectory, (ArchiveReport)null);
        for (ArchiveMetadata meta : archive.getNestedArchives()) {
            ArchiveReport temp = this.toArchiveReport(meta, reportDirectory);
            report.getNestedArchiveReports().add(temp);
        }
        if (this.resolver == null) {
            throw new IllegalStateException("Resolver not set for " + StaticHtmlReporter.class.getSimpleName());
        }
        for (FileMetadata fileMeta : archive.getEntries()) {
            MetaResultTransformer<?> transformer = this.resolver.resolveTransformer(fileMeta.getClass());
            ResourceReport data = transformer.toResourceReport(fileMeta, reportDirectory, report);
            report.getResourceReports().add(data);
        }
        return report;
    }
}

