/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.html.freemarker;

import freemarker.core.Environment;
import freemarker.ext.beans.StringModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.jboss.windup.metadata.decoration.Line;
import org.jboss.windup.reporting.html.ArchiveReport;
import org.jboss.windup.reporting.html.ResourceReport;
import org.jboss.windup.reporting.html.freemarker.PieSort;

public class PieSerializer
implements TemplateDirectiveModel {
    private static final String NL = "\n";
    private static final Log LOG = LogFactory.getLog(PieSerializer.class);

    public void execute(Environment env, Map map, TemplateModel[] templateModel, TemplateDirectiveBody templateDirectiveBody) throws TemplateException, IOException {
        StringModel stringModel = (StringModel)map.get("archive");
        ArchiveReport archiveReport = (ArchiveReport)stringModel.getWrappedObject();
        Map<String, Integer> data = PieSerializer.extractData(archiveReport);
        if (data.keySet().size() > 0) {
            env.getOut().append("<div class='archivePie'>");
            PieSerializer.drawPie(env.getOut(), archiveReport.getRelativePathFromRoot(), data);
            env.getOut().append("</div>");
        }
    }

    public static Map<String, Integer> recursePie(ArchiveReport ar) throws IOException {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        PieSerializer.recursePie(ar, data);
        return data;
    }

    public static void recursePie(ArchiveReport ar, Map<String, Integer> data) throws IOException {
        for (ArchiveReport arr : ar.getNestedArchiveReports()) {
            PieSerializer.recursePie(arr, data);
        }
        PieSerializer.extractData(ar, data);
    }

    public static void drawPie(Writer writer, ArchiveReport ar) throws IOException {
        PieSerializer.drawPie(writer, ar.getRelativePathFromRoot(), PieSerializer.extractData(ar));
    }

    public static Map<String, Integer> extractData(ArchiveReport ar) {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        return PieSerializer.extractData(ar, data);
    }

    public static Map<String, Integer> extractData(ArchiveReport ar, Map<String, Integer> data) {
        int val = 0;
        for (ResourceReport report : ar.getResourceReports()) {
            for (AbstractDecoration result : report.getDecorations()) {
                if (!(result instanceof Line)) continue;
                val = 1;
                String pattern = result.getPattern();
                String[] keyArray = pattern.split("\\.");
                String string = pattern = keyArray.length > 1 ? keyArray[0] + "." + keyArray[1] + ".*" : pattern;
                if (data.containsKey(pattern)) {
                    val = data.get(pattern);
                    ++val;
                }
                data.put(pattern, val);
            }
        }
        return data;
    }

    public static void drawPie(Writer writer, String archiveName, Map<String, Integer> data) throws IOException {
        if (data.size() == 0) {
            return;
        }
        List<PieSort> pieList = PieSerializer.topX(data, 9);
        String id = PieSerializer.generateId(archiveName);
        String dataId = "data_" + id;
        String pieId = id + "_Pie";
        writer.append("<div id='" + pieId + "' class='windupPieGraph'></div>");
        writer.append("<script type='text/javascript'>");
        writer.append(NL).append("$(function () {");
        writer.append(NL).append("\tvar " + dataId + " = [];");
        int i = 0;
        for (PieSort p : pieList) {
            writer.append(NL).append("\tdata_" + id + "[" + i + "] = { label: '" + p.key + "', data: " + p.value + " };");
            ++i;
        }
        writer.append(NL).append("\t$.plot($('#" + pieId + "'), " + dataId + ", {");
        writer.append(NL).append("\t\tseries: {");
        writer.append(NL).append("\t\t\tpie: {");
        writer.append(NL).append("\t\t\t\tshow: true");
        writer.append(NL).append("\t\t\t}");
        writer.append(NL).append("\t\t}");
        writer.append(NL).append("\t});");
        writer.append(NL).append("});");
        writer.append(NL).append("</script>");
    }

    private static String generateId(String archiveName) {
        String id = archiveName + UUID.randomUUID();
        id = id.replaceAll("[^A-Za-z0-9]", "");
        return id;
    }

    private static List<PieSort> topX(Map<String, Integer> map, int top) {
        List<PieSort> list = new ArrayList<PieSort>(map.keySet().size() + 1);
        for (String key : map.keySet()) {
            PieSort p = new PieSort(key + " - " + map.get(key), map.get(key));
            list.add(p);
        }
        Collections.sort(list);
        int other = 0;
        if (top < list.size()) {
            List bottomList = list.subList(top, list.size());
            for (PieSort p : bottomList) {
                other += p.value.intValue();
            }
            list = list.subList(0, top);
        }
        if (other > 0) {
            list.add(new PieSort("Other - " + other, other));
        }
        return list;
    }
}

