/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.html.writer;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.windup.reporting.html.ClasspathReport;

public class ClassloaderHtmlWriter {
    private static final Log LOG = LogFactory.getLog(ClassloaderHtmlWriter.class);
    private final Configuration cfg = new Configuration();

    public ClassloaderHtmlWriter() {
        this.cfg.setTemplateUpdateDelay(500);
        this.cfg.setClassForTemplateLoading(this.getClass(), "/");
    }

    public void writeBody(Writer writer, String sourceText, List<String> meta) throws IOException {
        Template template = this.cfg.getTemplate("/freemarker/classloader/classloader-report.ftl");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("classpathIssue", meta);
        this.toWriter(template, writer, data);
    }

    public void writeStatic(Writer writer, ClasspathReport classloaderIssues) throws IOException {
        Template template = this.cfg.getTemplate("/freemarker/classloader/classloader-static.ftl");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("classpathIssues", classloaderIssues.getMissingToAffected());
        data.put("relativePath", classloaderIssues.getRelativePathToRoot());
        this.toWriter(template, writer, data);
    }

    protected void toWriter(Template template, Writer writer, Map<String, Object> data) throws IOException {
        try {
            template.process(data, writer);
        }
        catch (TemplateException e) {
            throw new IOException("Exception writing template.", e);
        }
        finally {
            writer.close();
        }
    }
}

