/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.html.writer;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.windup.reporting.html.ArchiveReport;
import org.jboss.windup.reporting.html.freemarker.ArchiveReportSummarySerializer;
import org.jboss.windup.reporting.html.freemarker.PieSerializer;
import org.jboss.windup.reporting.html.freemarker.SourceModificationSerializer;
import org.jboss.windup.reporting.html.freemarker.SummaryPieSerializer;

public class SummaryHtmlWriter {
    private static final Log LOG = LogFactory.getLog(SummaryHtmlWriter.class);
    private final Configuration cfg = new Configuration();

    public SummaryHtmlWriter() {
        this.cfg.setTemplateUpdateDelay(500);
        this.cfg.setClassForTemplateLoading(this.getClass(), "/");
    }

    public void writeBody(Writer writer, ArchiveReport archiveReport) throws IOException {
        Template template = this.cfg.getTemplate("/freemarker/summary/summary-report.ftl");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("pie", new PieSerializer());
        data.put("overviewpie", new SummaryPieSerializer());
        data.put("archivesummary", new ArchiveReportSummarySerializer());
        data.put("modifier", new SourceModificationSerializer());
        data.put("archiveReport", archiveReport);
        this.toWriter(template, writer, data);
    }

    public void writeStatic(Writer writer, ArchiveReport archiveReport) throws IOException {
        Template template = this.cfg.getTemplate("/freemarker/summary/summary-static.ftl");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("pie", new PieSerializer());
        data.put("overviewpie", new SummaryPieSerializer());
        data.put("archivesummary", new ArchiveReportSummarySerializer());
        data.put("modifier", new SourceModificationSerializer());
        data.put("archiveReport", archiveReport);
        this.toWriter(template, writer, data);
    }

    protected void toWriter(Template template, Writer writer, Map<String, Object> data) throws IOException {
        try {
            template.process(data, writer);
        }
        catch (TemplateException e) {
            throw new IOException("Exception writing template.", e);
        }
        finally {
            writer.close();
        }
    }
}

