/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.spreadsheet;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.jboss.windup.metadata.decoration.Classification;
import org.jboss.windup.metadata.decoration.archetype.version.Version;
import org.jboss.windup.metadata.decoration.effort.StoryPointEffort;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.metadata.type.archive.ArchiveMetadata;
import org.jboss.windup.reporting.Reporter;
import org.jboss.windup.reporting.html.ArchiveReport;

public class ScorecardReporter
implements Reporter {
    private static final Log LOG = LogFactory.getLog(ScorecardReporter.class);
    private static final String TEST_PADDING = "3";

    protected File generateScorecardName(ArchiveMetadata archive, File reportDirectory) {
        Validate.notNull((Object)archive, (String)"Archive is required, but null.");
        Validate.notNull((Object)reportDirectory, (String)"Report directory is required, but null.");
        String scorecardName = "scorecard-" + StringUtils.replace((String)archive.getName(), (String)".", (String)"-") + ".xlsx";
        String outputName = reportDirectory.getAbsolutePath() + File.separator + scorecardName;
        File output = new File(outputName);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ArchiveMetadata archive, File reportDirectory) {
        Validate.notNull((Object)archive, (String)"Archive is required, but null.");
        Validate.notNull((Object)reportDirectory, (String)"Report directory is required, but null.");
        File output = this.generateScorecardName(archive, reportDirectory);
        List<ArchiveMetadata> results = this.unwind(archive);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(output);
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet s = workbook.createSheet("MigrationScoreCard");
            s.setColumnWidth(0, 17920);
            s.setColumnWidth(1, 5120);
            s.setColumnWidth(2, 2560);
            s.setColumnWidth(3, 65280);
            ScorecardReporter.appendTitleRow(workbook, s, 0);
            int rownum = 1;
            for (ArchiveMetadata result : results) {
                StringBuilder notes = new StringBuilder();
                for (AbstractDecoration dr : result.getDecorations()) {
                    if (!(dr instanceof Version)) continue;
                    notes.append(dr.toString());
                }
                HashSet<String> classifications = new HashSet<String>();
                double estimate = 0.0;
                for (FileMetadata ir : result.getEntries()) {
                    for (AbstractDecoration dr : ir.getDecorations()) {
                        if (dr instanceof Classification) {
                            String tempDesc = dr.getDescription();
                            tempDesc = StringUtils.removeStart((String)tempDesc, (String)"Classification: ");
                            classifications.add(tempDesc);
                        }
                        if (dr.getEffort() == null || !(dr.getEffort() instanceof StoryPointEffort)) continue;
                        estimate += (double)((StoryPointEffort)dr.getEffort()).getHours().intValue();
                    }
                }
                if (classifications.size() > 0) {
                    for (String classification : classifications) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Found: " + classification));
                        }
                        notes.append(", ").append(classification);
                    }
                }
                String notesExtracted = StringUtils.removeStart((String)notes.toString(), (String)", ");
                ScorecardReporter.appendNotesRow(workbook, s, rownum, result.getRelativePath(), estimate, notesExtracted);
                ++rownum;
            }
            ScorecardReporter.appendTotalRow(workbook, s, rownum++);
            int n = ++rownum;
            ScorecardReporter.appendMentoringTitleRow(workbook, s, n);
            int start = ++rownum + 1;
            ScorecardReporter.appendNotesRow(workbook, s, rownum++, "JBoss Configuration / Documentation / Mentoring", 80.0, "");
            ScorecardReporter.appendNotesRow(workbook, s, rownum++, "JBoss Server Setup for Apps", 80.0, "");
            ScorecardReporter.appendNotesRow(workbook, s, rownum++, "JBoss Operations Network Setup / Documentation / Mentoring", 120.0, "");
            ScorecardReporter.appendNotesRow(workbook, s, rownum++, "Deployment / Fail Over Plans", 80.0, "");
            int end = rownum;
            ScorecardReporter.appendMentoringTotalRow(workbook, s, rownum++, start, end);
            workbook.write((OutputStream)out);
        }
        catch (IOException e) {
            try {
                LOG.error((Object)("Exception writing scorecard to: " + output.getAbsolutePath()));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    private List<ArchiveMetadata> unwind(ArchiveMetadata result) {
        LinkedList<ArchiveMetadata> unwound = new LinkedList<ArchiveMetadata>();
        this.unwind(result, unwound);
        return unwound;
    }

    private void unwind(ArchiveMetadata result, List<ArchiveMetadata> unwound) {
        for (ArchiveMetadata meta : result.getNestedArchives()) {
            this.unwind(meta, unwound);
        }
        unwound.add(result);
    }

    private static void appendTotalRow(XSSFWorkbook wb, XSSFSheet sheet, int rowNum) {
        XSSFFont boldFont = wb.createFont();
        boldFont.setBoldweight((short)700);
        boldFont.setColor((short)0);
        XSSFCellStyle commentCell = wb.createCellStyle();
        commentCell.setBorderTop((short)1);
        XSSFCellStyle totalCell = wb.createCellStyle();
        totalCell.setBorderTop((short)1);
        totalCell.setFont((Font)boldFont);
        XSSFCellStyle totalCellRight = wb.createCellStyle();
        totalCellRight.setBorderTop((short)1);
        totalCellRight.setAlignment(HorizontalAlignment.RIGHT);
        totalCellRight.setFont((Font)boldFont);
        XSSFRow row = sheet.createRow(rowNum);
        XSSFCell t1 = row.createCell(0);
        t1.setCellValue("Total:");
        t1.setCellStyle((CellStyle)totalCellRight);
        XSSFCell t2 = row.createCell(1);
        t2.setCellFormula("SUM(B1:B" + rowNum + ")*" + TEST_PADDING);
        t2.setCellStyle((CellStyle)totalCell);
        XSSFCell t3 = row.createCell(2);
        t3.setCellStyle((CellStyle)totalCell);
        XSSFCell t4 = row.createCell(3);
        t4.setCellValue("Total with Testing & App Migration Factors");
        t4.setCellStyle((CellStyle)commentCell);
    }

    private static void appendTitleRow(XSSFWorkbook wb, XSSFSheet sheet, int rowNum) {
        XSSFCellStyle titleCell = wb.createCellStyle();
        Color titleCellGrey = new Color(0xECECEC);
        XSSFColor color = new XSSFColor(titleCellGrey);
        titleCell.setFillForegroundColor(color);
        titleCell.setBorderBottom((short)2);
        titleCell.setFillPattern((short)1);
        XSSFFont titleFormat = wb.createFont();
        titleFormat.setBoldweight((short)700);
        titleFormat.setColor((short)0);
        titleCell.setFont((Font)titleFormat);
        XSSFRow row = sheet.createRow(rowNum);
        XSSFCell t1 = row.createCell(0);
        t1.setCellValue("Application Migration Estimate");
        t1.setCellStyle((CellStyle)titleCell);
        XSSFCell t2 = row.createCell(1);
        t2.setCellValue("Effort (Points)");
        t2.setCellStyle((CellStyle)titleCell);
        XSSFCell t3 = row.createCell(2);
        t3.setCellStyle((CellStyle)titleCell);
        XSSFCell t4 = row.createCell(3);
        t4.setCellValue("Notes");
        t4.setCellStyle((CellStyle)titleCell);
    }

    private static void appendMentoringTitleRow(XSSFWorkbook wb, XSSFSheet sheet, int rowNum) {
        XSSFCellStyle titleCell = wb.createCellStyle();
        Color titleCellGrey = new Color(0xECECEC);
        XSSFColor color = new XSSFColor(titleCellGrey);
        titleCell.setFillForegroundColor(color);
        titleCell.setBorderBottom((short)2);
        titleCell.setBorderTop((short)2);
        titleCell.setFillPattern((short)1);
        XSSFFont titleFormat = wb.createFont();
        titleFormat.setBoldweight((short)700);
        titleFormat.setColor((short)0);
        titleCell.setFont((Font)titleFormat);
        XSSFRow row = sheet.createRow(rowNum);
        XSSFCell t1 = row.createCell(0);
        t1.setCellValue("Migration Service Estimate");
        t1.setCellStyle((CellStyle)titleCell);
        XSSFCell t2 = row.createCell(1);
        t2.setCellStyle((CellStyle)titleCell);
        XSSFCell t3 = row.createCell(2);
        t3.setCellStyle((CellStyle)titleCell);
        XSSFCell t4 = row.createCell(3);
        t4.setCellStyle((CellStyle)titleCell);
    }

    private static void appendMentoringTotalRow(XSSFWorkbook wb, XSSFSheet sheet, int rowNum, int start, int end) {
        XSSFFont boldFont = wb.createFont();
        boldFont.setBoldweight((short)700);
        boldFont.setColor((short)0);
        XSSFCellStyle commentCell = wb.createCellStyle();
        commentCell.setBorderTop((short)1);
        XSSFCellStyle totalCell = wb.createCellStyle();
        totalCell.setBorderTop((short)1);
        totalCell.setFont((Font)boldFont);
        XSSFCellStyle totalCellRight = wb.createCellStyle();
        totalCellRight.setBorderTop((short)1);
        totalCellRight.setAlignment(HorizontalAlignment.RIGHT);
        totalCellRight.setFont((Font)boldFont);
        XSSFRow row = sheet.createRow(rowNum);
        XSSFCell t1 = row.createCell(0);
        t1.setCellValue("Total:");
        t1.setCellStyle((CellStyle)totalCellRight);
        XSSFCell t2 = row.createCell(1);
        t2.setCellFormula("SUM(B" + start + ":B" + end + ")");
        t2.setCellStyle((CellStyle)totalCell);
        XSSFCell t3 = row.createCell(2);
        t3.setCellStyle((CellStyle)totalCell);
        XSSFCell t4 = row.createCell(3);
        t4.setCellStyle((CellStyle)commentCell);
    }

    private static void appendNotesRow(XSSFWorkbook wb, XSSFSheet sheet, int rowNum, String app, double effort, String notes) {
        XSSFRow row = sheet.createRow(rowNum);
        XSSFCell t1 = row.createCell(0);
        t1.setCellValue(app);
        XSSFCell t2 = row.createCell(1);
        XSSFCellStyle t2s = wb.createCellStyle();
        t2s.setAlignment(HorizontalAlignment.RIGHT);
        t2.setCellStyle((CellStyle)t2s);
        t2.setCellValue(effort);
        row.createCell(2);
        XSSFCell t4 = row.createCell(3);
        t4.setCellValue(notes);
    }

    public static void generateScoreCard(File output, List<ArchiveReport> results) {
    }
}

