/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.transformers;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.IntRange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.windup.metadata.decoration.AbstractDecoration;
import org.jboss.windup.metadata.decoration.Classification;
import org.jboss.windup.metadata.decoration.Line;
import org.jboss.windup.metadata.decoration.Summary;
import org.jboss.windup.metadata.decoration.archetype.VendorResult;
import org.jboss.windup.metadata.decoration.effort.Effort;
import org.jboss.windup.metadata.decoration.effort.StoryPointEffort;
import org.jboss.windup.metadata.decoration.effort.UnknownEffort;
import org.jboss.windup.metadata.type.FileMetadata;
import org.jboss.windup.metadata.type.ResourceMetadata;
import org.jboss.windup.metadata.type.archive.ArchiveMetadata;
import org.jboss.windup.reporting.ReportUtil;
import org.jboss.windup.reporting.data.ResourceData;
import org.jboss.windup.reporting.html.ArchiveReport;
import org.jboss.windup.reporting.html.ResourceReport;

public abstract class MetaResultTransformer<T extends ResourceMetadata> {
    private static final Log LOG = LogFactory.getLog(MetaResultTransformer.class);

    protected void populateResourceData(T meta, File reportDirectory, ResourceData data) {
        if (data == null) {
            throw new IllegalArgumentException("ResourceData must not be null.");
        }
        File file = meta.getFilePointer();
        data.setSyntax(this.buildSyntax());
        data.setDecorations(meta.getDecorations());
        data.setRelativePathToRoot(ReportUtil.calculateRelativePathToRoot(reportDirectory, file));
        data.setRelativePathFromRoot(ReportUtil.calculateRelativePathFromRoot(reportDirectory, file));
    }

    public ResourceReport toResourceReport(T meta, File reportDirectory, ArchiveReport parent) {
        ResourceReport report = new ResourceReport();
        report.setTitle(this.buildTitle(meta, reportDirectory));
        report.setSummary(this.buildSummary(meta));
        this.populateResourceData(meta, reportDirectory, report);
        report.setEffort(this.calculateEffort(report.getDecorations()));
        report.setSourceModification(this.buildSourceModification(meta));
        return report;
    }

    public ResourceData toResourceData(T meta, File reportDirectory) {
        ResourceData resourceData = new ResourceData();
        this.populateResourceData(meta, reportDirectory, resourceData);
        return resourceData;
    }

    protected Effort calculateEffort(Collection<AbstractDecoration> results) {
        int effortCount = 0;
        boolean unknownEffort = false;
        for (AbstractDecoration result : results) {
            if (result.getEffort() instanceof StoryPointEffort) {
                effortCount += ((StoryPointEffort)result.getEffort()).getHours().intValue();
            }
            if (!(result.getEffort() instanceof UnknownEffort)) continue;
        }
        if (unknownEffort) {
            return new UnknownEffort();
        }
        return new StoryPointEffort(Integer.valueOf(effortCount));
    }

    protected String buildSummary(T meta) {
        StringBuilder summary = new StringBuilder();
        for (AbstractDecoration result : meta.getDecorations()) {
            if (result instanceof Classification) {
                summary.append("Classification: " + result.getDescription() + "<br />");
            }
            if (!(result instanceof Summary)) continue;
            summary.append(result.getDescription() + "<br />");
        }
        return summary.toString();
    }

    protected boolean[] buildSourceModification(T meta) {
        LinkedList<Line> lrs = new LinkedList<Line>();
        for (AbstractDecoration result : meta.getDecorations()) {
            if (!(result instanceof Line) || !result.getLevel().isLevel(AbstractDecoration.NotificationLevel.WARNING)) continue;
            lrs.add((Line)result);
        }
        if (lrs.size() > 0) {
            try {
                IntRange[] ranges;
                int numLines = FileUtils.readLines((File)meta.getFilePointer()).size();
                int twentyPercent = (int)Math.floor((double)numLines * 0.2);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("File: " + meta.getFilePointer().getAbsolutePath()));
                    LOG.debug((Object)("Number of lines: " + numLines));
                    LOG.debug((Object)("20 Percent: " + twentyPercent));
                }
                boolean[] isRed = new boolean[]{false, false, false, false, false};
                ranges = new IntRange[]{new IntRange(0, twentyPercent), new IntRange(ranges[0].getMaximumInteger() + 1, ranges[0].getMaximumInteger() + twentyPercent), new IntRange(ranges[1].getMaximumInteger() + 1, ranges[1].getMaximumInteger() + twentyPercent), new IntRange(ranges[2].getMaximumInteger() + 1, ranges[2].getMaximumInteger() + twentyPercent), new IntRange(ranges[3].getMaximumInteger() + 1, numLines)};
                for (Line lr : lrs) {
                    int rTotal = ranges.length;
                    for (int rIter = 0; rIter < rTotal; ++rIter) {
                        if (!ranges[rIter].containsInteger((Number)lr.getLineNumber())) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Line: " + lr.getLineNumber() + " within range[" + rIter + "]: " + ranges[rIter].toString()));
                        }
                        isRed[rIter] = true;
                    }
                }
                return isRed;
            }
            catch (IOException e) {
                LOG.error((Object)"Exception reading file.", (Throwable)e);
            }
        }
        return null;
    }

    protected boolean buildVendorResult(ArchiveMetadata meta) {
        for (AbstractDecoration result : meta.getDecorations()) {
            if (!(result instanceof VendorResult)) continue;
            return true;
        }
        return false;
    }

    protected String buildTitle(T meta, File rootDirectory) {
        String title = StringUtils.removeStart((String)meta.getFilePointer().getAbsolutePath(), (String)rootDirectory.getAbsolutePath());
        title = StringUtils.replace((String)title, (String)"\\", (String)"/");
        title = StringUtils.removeStart((String)title, (String)"/");
        if (meta instanceof FileMetadata) {
            String starter = ((FileMetadata)meta).getArchiveMeta().getRelativePath();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing: " + starter + " from " + title));
            }
            title = StringUtils.removeStart((String)title, (String)starter);
        }
        title = StringUtils.removeStart((String)title, (String)"/");
        return title;
    }

    protected abstract String buildSyntax();

    protected Effort buildEffort(T meta) {
        Effort effort = this.calculateEffort(meta.getDecorations());
        return effort;
    }

    protected Class<?> transformerType() {
        Class result = null;
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] fieldArgTypes = pt.getActualTypeArguments();
            result = (Class)fieldArgTypes[0];
        }
        return result;
    }
}

