/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.tools;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.cxf.tools.java2ws.JavaToWS;
import org.jboss.ws.tools.io.NullPrintStream;
import org.jboss.wsf.spi.tools.WSContractProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CXFProviderImpl
extends WSContractProvider {
    private ClassLoader loader;
    private boolean generateWsdl = false;
    private boolean generateSource = false;
    private File outputDir = new File("output");
    private File resourceDir = null;
    private File sourceDir = null;
    private PrintStream messageStream;

    public void setGenerateWsdl(boolean generateWsdl) {
        this.generateWsdl = generateWsdl;
    }

    public void setGenerateSource(boolean generateSource) {
        this.generateSource = generateSource;
    }

    public void setOutputDirectory(File directory) {
        this.outputDir = directory;
    }

    public void setResourceDirectory(File directory) {
        this.resourceDir = directory;
    }

    public void setSourceDirectory(File directory) {
        this.sourceDir = directory;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }

    public void provide(String endpointClass) {
        try {
            this.provide(this.loader.loadClass(endpointClass));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found: " + endpointClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provide(Class<?> endpointClass) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        if (this.loader != null) {
            Thread.currentThread().setContextClassLoader(this.loader);
        }
        try {
            String cp;
            PrintStream stream;
            File sourceDir;
            ArrayList<String> args = new ArrayList<String>();
            File resourceDir = this.resourceDir != null ? this.resourceDir : this.outputDir;
            File file = sourceDir = this.sourceDir != null ? this.sourceDir : this.outputDir;
            if (this.generateSource) {
                // empty if block
            }
            if (sourceDir != null) {
                if (!sourceDir.exists() && !sourceDir.mkdirs()) {
                    throw new IllegalStateException("Could not make directory: " + sourceDir.getName());
                }
                args.add("-s");
                args.add(sourceDir.getAbsolutePath());
            }
            if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
                throw new IllegalStateException("Could not make directory: " + this.outputDir.getName());
            }
            args.add("-classdir");
            args.add(this.outputDir.getAbsolutePath());
            if (resourceDir != null) {
                if (!resourceDir.exists() && !resourceDir.mkdirs()) {
                    throw new IllegalStateException("Could not make directory: " + resourceDir.getName());
                }
                args.add("-d");
                args.add(resourceDir.getAbsolutePath());
            }
            if ((stream = this.messageStream) != null) {
                args.add("-verbose");
            } else {
                stream = NullPrintStream.getInstance();
            }
            if (this.generateWsdl) {
                args.add("-wsdl");
            }
            if ((cp = this.buildClasspathString(this.loader)) != null) {
                args.add("-cp");
                args.add(cp);
            }
            args.add("-wrapperbean");
            args.add(endpointClass.getCanonicalName());
            JavaToWS j2w = new JavaToWS(args.toArray(new String[0]));
            j2w.run((OutputStream)stream);
        }
        catch (Throwable t) {
            if (this.messageStream != null) {
                this.messageStream.println("Failed to invoke JavaToWS");
                t.printStackTrace(this.messageStream);
            } else {
                t.printStackTrace();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private String buildClasspathString(ClassLoader cl) {
        String cp = null;
        if (cl instanceof URLClassLoader) {
            String parentPath;
            StringBuilder builder = new StringBuilder();
            URLClassLoader urlLoader = (URLClassLoader)cl;
            for (URL url : urlLoader.getURLs()) {
                builder.append(url.getPath());
                builder.append(File.pathSeparator);
            }
            if (cl.getParent() != null && (parentPath = this.buildClasspathString(cl.getParent())) != null) {
                builder.append(parentPath);
            }
            cp = builder.toString();
        }
        return cp;
    }
}

