/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client;

import java.util.HashMap;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;

public class ServiceRefStubPropertyConfigurer
implements Configurer {
    private UnifiedServiceRefMetaData serviceRefMD;
    private Configurer delegate;

    public ServiceRefStubPropertyConfigurer(UnifiedServiceRefMetaData serviceRefMD, Configurer delegate) {
        this.serviceRefMD = serviceRefMD;
        this.delegate = delegate;
    }

    public void configureBean(Object beanInstance) {
        if (beanInstance instanceof JaxWsProxyFactoryBean) {
            this.configureJaxWsProxyFactoryBean((JaxWsProxyFactoryBean)beanInstance);
        }
        if (this.delegate != null) {
            this.delegate.configureBean(beanInstance);
        }
    }

    public void configureBean(String name, Object beanInstance) {
        if (beanInstance instanceof JaxWsProxyFactoryBean) {
            this.configureJaxWsProxyFactoryBean((JaxWsProxyFactoryBean)beanInstance);
        }
        if (this.delegate != null) {
            this.delegate.configureBean(name, beanInstance);
        }
    }

    private synchronized void configureJaxWsProxyFactoryBean(JaxWsProxyFactoryBean proxyFactory) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (UnifiedPortComponentRefMetaData pcRef : this.serviceRefMD.getPortComponentRefs()) {
            String sei = pcRef.getServiceEndpointInterface();
            if (sei == null || !sei.equals(proxyFactory.getServiceClass().getName())) continue;
            for (UnifiedStubPropertyMetaData prop : pcRef.getStubProperties()) {
                properties.put(prop.getPropName(), prop.getPropValue());
            }
        }
        proxyFactory.setProperties(properties);
    }
}

