/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.extensions.addressing.map;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.ReferenceParametersType;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.addressing.MAP;
import org.jboss.wsf.common.addressing.MAPBuilder;
import org.jboss.wsf.common.addressing.MAPEndpoint;
import org.jboss.wsf.common.addressing.MAPRelatesTo;
import org.jboss.wsf.stack.cxf.extensions.addressing.map.CXFMAPBuilder;
import org.jboss.wsf.stack.cxf.extensions.addressing.map.CXFMAPEndpoint;
import org.w3c.dom.Element;

public class CXFMAP
implements MAP {
    private static final Logger log = Logger.getLogger(CXFMAP.class);
    private AddressingProperties implementation;

    CXFMAP(AddressingProperties implementation) {
        this.implementation = implementation;
    }

    public String getTo() {
        AttributedURIType to = this.implementation.getTo();
        return to != null ? to.getValue() : null;
    }

    public MAPEndpoint getFrom() {
        EndpointReferenceType from = this.implementation.getFrom();
        return from != null ? new CXFMAPEndpoint(from) : null;
    }

    public String getMessageID() {
        AttributedURIType messageId = this.implementation.getMessageID();
        return messageId != null ? messageId.getValue() : null;
    }

    public String getAction() {
        AttributedURIType action = this.implementation.getAction();
        return action != null ? action.getValue() : null;
    }

    public MAPEndpoint getFaultTo() {
        EndpointReferenceType faultTo = this.implementation.getFaultTo();
        return faultTo != null ? new CXFMAPEndpoint(faultTo) : null;
    }

    public MAPEndpoint getReplyTo() {
        EndpointReferenceType replyTo = this.implementation.getReplyTo();
        return replyTo != null ? new CXFMAPEndpoint(replyTo) : null;
    }

    public MAPRelatesTo getRelatesTo() {
        MAPBuilder builder = CXFMAPBuilder.getBuilder();
        RelatesToType relatesTo = this.implementation.getRelatesTo();
        if (relatesTo != null) {
            String type = relatesTo.getRelationshipType();
            int index = type.indexOf("}");
            String ns = type.substring(1, index + 1);
            String name = type.substring(index + 1);
            return builder.newRelatesTo(relatesTo.getValue(), new QName(ns, name));
        }
        return null;
    }

    public void setTo(String address) {
        if (address != null) {
            EndpointReferenceType epref = new EndpointReferenceType();
            AttributedURIType uri = new AttributedURIType();
            uri.setValue(address);
            epref.setAddress(uri);
            this.implementation.setTo(epref);
        } else {
            this.implementation.setTo((EndpointReferenceType)null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFrom(MAPEndpoint epref) {
        if (epref != null) {
            if (!(epref instanceof CXFMAPEndpoint)) throw new IllegalArgumentException("Unsupported MAPEndpoint: " + epref);
            this.implementation.setFrom(((CXFMAPEndpoint)epref).getImplementation());
            return;
        } else {
            this.implementation.setFrom(null);
        }
    }

    public void setMessageID(String messageID) {
        if (messageID != null) {
            AttributedURIType uri = new AttributedURIType();
            uri.setValue(messageID);
            this.implementation.setMessageID(uri);
        } else {
            this.implementation.setMessageID(null);
        }
    }

    public void setAction(String action) {
        if (action != null) {
            AttributedURIType uri = new AttributedURIType();
            uri.setValue(action);
            this.implementation.setAction(uri);
        } else {
            this.implementation.setAction(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setReplyTo(MAPEndpoint epref) {
        if (epref != null) {
            if (!(epref instanceof CXFMAPEndpoint)) throw new IllegalArgumentException("Unsupported MAPEndpoint: " + epref);
            this.implementation.setReplyTo(((CXFMAPEndpoint)epref).getImplementation());
            return;
        } else {
            this.implementation.setReplyTo(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFaultTo(MAPEndpoint epref) {
        if (epref != null) {
            if (!(epref instanceof CXFMAPEndpoint)) throw new IllegalArgumentException("Unsupported MAPEndpoint: " + epref);
            this.implementation.setFaultTo(((CXFMAPEndpoint)epref).getImplementation());
            return;
        } else {
            this.implementation.setFaultTo(null);
        }
    }

    public void setRelatesTo(MAPRelatesTo relatesTo) {
        if (relatesTo != null) {
            RelatesToType relatesToImpl = new RelatesToType();
            relatesToImpl.setValue(relatesTo.getRelatesTo());
            relatesToImpl.setRelationshipType(relatesTo.getType().toString());
            this.implementation.setRelatesTo(relatesToImpl);
        } else {
            this.implementation.setRelatesTo(null);
        }
    }

    public void addReferenceParameter(Element refParam) {
        EndpointReferenceType eprt = this.implementation.getToEndpointReference();
        ReferenceParametersType refParams = eprt.getReferenceParameters();
        if (refParams == null) {
            refParams = new ReferenceParametersType();
            eprt.setReferenceParameters(refParams);
        }
        eprt.getReferenceParameters().getAny().add(refParam);
    }

    public void initializeAsDestination(MAPEndpoint epref) {
        if (epref == null) {
            throw new IllegalArgumentException("Invalid null endpoint reference");
        }
        if (!(epref instanceof CXFMAPEndpoint)) {
            throw new IllegalArgumentException("Unsupported MAPEndpoint: " + epref);
        }
        this.implementation.setTo(((CXFMAPEndpoint)epref).getImplementation());
    }

    public List<Object> getReferenceParameters() {
        List any;
        LinkedList<Object> list = new LinkedList<Object>();
        ReferenceParametersType refParams = this.implementation.getToEndpointReference().getReferenceParameters();
        if (refParams != null && (any = refParams.getAny()) != null) {
            list.addAll(any);
        }
        return list;
    }

    public void installOutboundMapOnClientSide(Map<String, Object> requestContext, MAP map) {
        if (!(map instanceof CXFMAP)) {
            throw new IllegalArgumentException("Unsupported MAP: " + map);
        }
        AddressingProperties addressingProperties = ((CXFMAP)map).implementation;
        requestContext.put("javax.xml.ws.addressing.context", addressingProperties);
        requestContext.put("javax.xml.ws.addressing.context.outbound", addressingProperties);
    }

    public void installOutboundMapOnServerSide(Map<String, Object> requestContext, MAP map) {
        if (!(map instanceof CXFMAP)) {
            throw new IllegalArgumentException("Unsupported MAP: " + map);
        }
        AddressingProperties addressingProperties = ((CXFMAP)map).implementation;
        requestContext.put("javax.xml.ws.addressing.context.outbound", addressingProperties);
    }
}

