/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSBusApplicationContext;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class JBossWSSpringBusFactory
extends SpringBusFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(JBossWSSpringBusFactory.class);

    public JBossWSSpringBusFactory() {
    }

    public JBossWSSpringBusFactory(ApplicationContext context) {
        super(context);
    }

    public Bus createBus(String[] cfgFiles, boolean includeDefaults) {
        try {
            return this.finishCreatingBus(this.createApplicationContext(cfgFiles, includeDefaults));
        }
        catch (BeansException ex) {
            LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"APP_CONTEXT_CREATION_FAILED_MSG", (Throwable)ex, (Object[])null);
            throw new RuntimeException(ex);
        }
    }

    public Bus createBus(URL[] urls, boolean includeDefaults) {
        try {
            return this.finishCreatingBus(new JBossWSBusApplicationContext(urls, includeDefaults, this.getApplicationContext()));
        }
        catch (BeansException ex) {
            LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"APP_CONTEXT_CREATION_FAILED_MSG", (Throwable)ex, (Object[])null);
            throw new RuntimeException(ex);
        }
    }

    private Bus finishCreatingBus(BusApplicationContext bac) {
        Bus bus = (Bus)bac.getBean("cxf");
        bus.setExtension((Object)bac, BusApplicationContext.class);
        JBossWSSpringBusFactory.possiblySetDefaultBus((Bus)bus);
        this.initializeBus(bus);
        this.registerAppContextLifeCycleListener(bus, bac);
        return bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BusApplicationContext createApplicationContext(String[] cfgFiles, boolean includeDefaults) {
        try {
            return new JBossWSBusApplicationContext(cfgFiles, includeDefaults, this.getApplicationContext());
        }
        catch (BeansException ex) {
            LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"INITIAL_APP_CONTEXT_CREATION_FAILED_MSG", (Throwable)ex, (Object[])null);
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            if (contextLoader != BusApplicationContext.class.getClassLoader()) {
                Thread.currentThread().setContextClassLoader(BusApplicationContext.class.getClassLoader());
                try {
                    JBossWSBusApplicationContext jBossWSBusApplicationContext = new JBossWSBusApplicationContext(cfgFiles, includeDefaults, this.getApplicationContext());
                    return jBossWSBusApplicationContext;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(contextLoader);
                }
            }
            throw ex;
        }
    }

    void registerAppContextLifeCycleListener(Bus bus, BusApplicationContext bac) {
        BusLifeCycleManager lm = (BusLifeCycleManager)bus.getExtension(BusLifeCycleManager.class);
        if (null != lm) {
            lm.registerLifeCycleListener((BusLifeCycleListener)new BusApplicationContextLifeCycleListener(bac));
        }
    }

    static class BusApplicationContextLifeCycleListener
    implements BusLifeCycleListener {
        private BusApplicationContext bac;

        BusApplicationContextLifeCycleListener(BusApplicationContext b) {
            this.bac = b;
        }

        public void initComplete() {
        }

        public void preShutdown() {
        }

        public void postShutdown() {
            this.bac.close();
        }
    }
}

