/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.jaspi;

import jakarta.xml.soap.SOAPMessage;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthContext;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapPreProtocolOutInterceptor;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.jboss.security.auth.message.GenericMessageInfo;

public class JaspiServerAuthenticator {
    public static final String JASPI_SECURITY_DOMAIN = "jaspi.security.domain";
    private final ServerAuthContext sctx;

    public JaspiServerAuthenticator(ServerAuthContext sctx) {
        this.sctx = sctx;
    }

    public void validateRequest(SoapMessage message) {
        AuthStatus authStatus;
        SOAPMessage soapMessage = (SOAPMessage)message.getContent(SOAPMessage.class);
        GenericMessageInfo messageInfo = new GenericMessageInfo((Object)soapMessage, null);
        try {
            authStatus = this.sctx.validateRequest((MessageInfo)messageInfo, null, null);
        }
        catch (AuthException e) {
            if (this.isSOAP12((Message)message)) {
                SoapFault soap12Fault = new SoapFault(e.getMessage(), Soap12.getInstance().getReceiver());
                throw soap12Fault;
            }
            throw new SoapFault(e.getMessage(), new QName("", "jaspi AuthException"));
        }
        MessageImpl response = null;
        if (messageInfo.getResponseMessage() != null && !message.getExchange().isOneWay()) {
            Endpoint e = message.getExchange().getEndpoint();
            response = new MessageImpl();
            response.setExchange(message.getExchange());
            response = e.getBinding().createMessage((Message)response);
            message.getExchange().setOutMessage((Message)response);
            response.setContent(SOAPMessage.class, messageInfo.getResponseMessage());
            if (AuthStatus.SEND_CONTINUE == authStatus) {
                response.put((Object)Message.RESPONSE_CODE, (Object)303);
            }
            if (AuthStatus.SEND_FAILURE == authStatus) {
                response.put((Object)Message.RESPONSE_CODE, (Object)500);
            }
            message.getInterceptorChain().abort();
            InterceptorChain chain = OutgoingChainInterceptor.getOutInterceptorChain((Exchange)message.getExchange());
            response.setInterceptorChain(chain);
            chain.doInterceptStartingAfter((Message)response, SoapPreProtocolOutInterceptor.class.getName());
        }
    }

    public void secureResponse(SoapMessage message) {
        SOAPMessage request = (SOAPMessage)message.getExchange().getInMessage().get(SOAPMessage.class);
        SOAPMessage response = (SOAPMessage)message.getContent(SOAPMessage.class);
        GenericMessageInfo messageInfo = new GenericMessageInfo((Object)request, (Object)response);
        AuthStatus authStatus = null;
        try {
            authStatus = this.sctx.secureResponse((MessageInfo)messageInfo, null);
        }
        catch (AuthException e) {
            if (this.isSOAP12((Message)message)) {
                SoapFault soap12Fault = new SoapFault(e.getMessage(), Soap12.getInstance().getReceiver());
                throw soap12Fault;
            }
            throw new SoapFault(e.getMessage(), new QName("", "jaspi AuthException"));
        }
        if (messageInfo.getResponseMessage() != null && !message.getExchange().isOneWay()) {
            if (AuthStatus.SEND_CONTINUE == authStatus) {
                message.put(Message.RESPONSE_CODE, (Object)303);
            }
            if (AuthStatus.SEND_FAILURE == authStatus) {
                message.put(Message.RESPONSE_CODE, (Object)500);
            }
        }
    }

    private boolean isSOAP12(Message message) {
        SoapBinding binding;
        return message.getExchange().getBinding() instanceof SoapBinding && (binding = (SoapBinding)message.getExchange().getBinding()).getSoapVersion() == Soap12.getInstance();
    }
}

