/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.jaspi.client;

import jakarta.xml.soap.SOAPMessage;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ClientAuthConfig;
import javax.security.auth.message.config.ClientAuthContext;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.message.Message;
import org.jboss.security.auth.login.JASPIAuthenticationInfo;
import org.jboss.security.auth.message.GenericMessageInfo;

public class JaspiClientAuthenticator {
    public static final String JASPI_SECURITY_DOMAIN = "jaspi.security.domain";
    private final ClientAuthConfig clientConfig;
    private final String securityDomain;
    private final JASPIAuthenticationInfo jpi;

    public JaspiClientAuthenticator(ClientAuthConfig clientConfig, String securityDomain, JASPIAuthenticationInfo jpi) {
        this.clientConfig = clientConfig;
        this.securityDomain = securityDomain;
        this.jpi = jpi;
    }

    public void secureRequest(SoapMessage message) {
        SOAPMessage soapMessage = (SOAPMessage)message.getContent(SOAPMessage.class);
        GenericMessageInfo messageInfo = new GenericMessageInfo((Object)soapMessage, null);
        String authContextID = this.clientConfig.getAuthContextID((MessageInfo)messageInfo);
        Properties serverContextProperties = new Properties();
        serverContextProperties.put("security-domain", this.securityDomain);
        serverContextProperties.put("jaspi-policy", this.jpi);
        Subject clientSubject = new Subject();
        AuthStatus authStatus = null;
        try {
            ClientAuthContext cctx = this.clientConfig.getAuthContext(authContextID, clientSubject, (Map)serverContextProperties);
            authStatus = cctx.secureRequest((MessageInfo)messageInfo, clientSubject);
        }
        catch (AuthException e) {
            if (this.isSOAP12((Message)message)) {
                SoapFault soap12Fault = new SoapFault(e.getMessage(), Soap12.getInstance().getSender());
                throw soap12Fault;
            }
            throw new SoapFault(e.getMessage(), new QName("", "japsi AuthException"));
        }
    }

    public void validateResponse(SoapMessage message) {
        SOAPMessage request = (SOAPMessage)message.getExchange().getInMessage().get(SOAPMessage.class);
        SOAPMessage response = (SOAPMessage)message.getContent(SOAPMessage.class);
        GenericMessageInfo messageInfo = new GenericMessageInfo((Object)request, (Object)response);
        String authContextID = this.clientConfig.getAuthContextID((MessageInfo)messageInfo);
        Properties serverContextProperties = new Properties();
        serverContextProperties.put("security-domain", this.securityDomain);
        serverContextProperties.put("jaspi-policy", this.jpi);
        Subject clientSubject = new Subject();
        AuthStatus authStatus = null;
        try {
            ClientAuthContext sctx = this.clientConfig.getAuthContext(authContextID, clientSubject, (Map)serverContextProperties);
            authStatus = sctx.validateResponse((MessageInfo)messageInfo, new Subject(), new Subject());
        }
        catch (AuthException e) {
            if (this.isSOAP12((Message)message)) {
                SoapFault soap12Fault = new SoapFault(e.getMessage(), Soap12.getInstance().getSender());
                throw soap12Fault;
            }
            throw new SoapFault(e.getMessage(), new QName("", "japsi AuthException"));
        }
    }

    private boolean isSOAP12(Message message) {
        SoapBinding binding;
        return message.getExchange().getBinding() instanceof SoapBinding && (binding = (SoapBinding)message.getExchange().getBinding()).getSoapVersion() == Soap12.getInstance();
    }
}

